package opale.tools;
/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/

import java.io.*;

/**
* This class offers methods to read/write on standard out and error out.
* @author O.C.
* @since Opale-Tools 0.12
*/
public class Stdio
{
private final static boolean COUNT=false;
private final static boolean OUT_OK=true;
private final static boolean ERR_OK=true;
private static  long cpt;
private static BufferedReader in;

static 
	{
	in = new BufferedReader(new InputStreamReader(System.in));
	}
	
/**
* Print a string on standard output.
* @param String s, a string
*/
public static  void print(String s)
	{
	if (OUT_OK) System.out.print(s);
	}

/**
* Print a string on standard output and terminate the line.
* @param String s, a string
*/
public static  void println(String s)
	{
	if (OUT_OK) System.out.println(s);
	}

/**
* Print a string on standard error output.
* @param String s, a string
*/
public static  void printerr(String s)
	{
	if (ERR_OK) System.err.print(s);
	}

/**
* Print a string on standard error output and terminate the line.
* @param String s, a string
*/
public static  void printerrln(String s)
	{
	if (ERR_OK) System.err.println(s);
	}


/**
* Reads a string on standard input.
* @return String, a string
*/
public static String input() 
	{
	try
	{
	return in.readLine();
	}
	catch (java.io.IOException e)
	{
	return null;
	}
	}

/**
* Print a message and read a string on standard input.
* @param String, a message
* @return String, a string
* @since Opale-Tools 0.13
*/
public static String input(String s) 
	{
	print(s+" ");
	try
	{
	return in.readLine();
	}
	catch (java.io.IOException e)
	{
	return null;
	}
	}
/**
* Reads an integer on standard input.
* @return int, an integer 
* @since Opale-Tools 0.13
*/
public static int inputInt() 
	{
	boolean b=true;
	int n = 0;
	
	while(b)
		{
		try
		{
		String s = in.readLine();
		n  = Integer.parseInt(s);
		b = false;
		}
		catch (java.io.IOException e)
		{
		b = false;
		}
		catch (java.lang.NumberFormatException e)
		{
		b = true;
		}
		
		}
	return n;
	}

/**
* Print a message and read an integer on standard input.
* @param String, a message
* @return int, an integer 
* @since Opale-Tools 0.13
*/
public static int inputInt(String s) 
	{
	boolean b=true;
	int n = 0;
	
	while(b)
		{
		try
		{
		print(s+" ");
		String ss = in.readLine();
		n  = Integer.parseInt(ss);
		b = false;
		}
		catch (java.io.IOException e)
		{
		b = false;
		}
		catch (java.lang.NumberFormatException e)
		{
		b = true;
		}
		
		}
	return n;
	}

/**
* Reads an real number on standard input.
* @return double, a double 
* @since Opale-Tools 0.13
*/
public static double inputDouble() 
	{
	boolean b=true;
	double x = 0;
	
	while(b)
		{
		try
		{
		String s = in.readLine();
		x  = Double.parseDouble(s);
		b = false;
		}
		catch (java.io.IOException e)
		{
		b = false;
		}
		catch (java.lang.NumberFormatException e)
		{
		b = true;
		}
		
		}
	return x;
	}


/**
* Print a message and read an real number on standard input.
* @param String, a message
* @return double, a double 
* @since Opale-Tools 0.13
*/
public static double inputDouble(String s) 
	{
	boolean b=true;
	double x = 0;
	
	while(b)
		{
		try
		{
		print(s+" ");
		String ss = in.readLine();
		x  = Double.parseDouble(ss);
		b = false;
		}
		catch (java.io.IOException e)
		{
		b = false;
		}
		catch (java.lang.NumberFormatException e)
		{
		b = true;
		}
		
		}
	return x;
	}
	
public static void main(String[] arg) throws java.io.IOException
	{
	Stdio.print("kjsdjkfhsdjk");
	Stdio.println("   kjsdjkfhsdjk");
	int n = Stdio.inputInt("Entrez un entier :");
	Stdio.println(""+n);
	double x = Stdio.inputDouble("Entrez un double :");
	Stdio.println(""+x);
	}

}



