package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.*;


/**
* Cette classe implmente le theta schma qui consiste  avancer en temps de la facon suivante : yn+1=yn+f(t,theta*yn+(1-theta)*yn+1).
* @author O.C.
* @since Opale-ODE 0.12
*/
public  final class ThetaScheme extends TimeScheme
{
private double theta;
/**
* This value represents the precision for the fix point method.
*/
//public static double PRECISION = 1.e-16;

/**
* This value fixes the maximum number of iterations in the algorithm.
*/ 
//public static int MAXITERATION = 100;


/**
* Par dfaut theta = 0.5
*/	
public ThetaScheme()
	{
	theta=0.5;
	}	

/**
* Permet de spcifier la valeur de theta
* @param double t
*/
public ThetaScheme(double t)
	{
	theta=t;
	}	
	
/**
* Cette mthode dfinit l'avanc en temps par la theta mthode.
*/	
public void forward(Equation eq)
	{
	int i=0,sortie=0;
	double cvg;

	DVect sol = new DVect(present());	
	f.eq=eq;
//	f.tmp = new DVect(present().size());
	f.theta = theta;
	
	FixPoint.solve(f,present().size(),present(), sol);
	
	//initialisation des conditions initiales
/*	DVect x = new DVect(present());	
	DVect sol = new DVect(present());	
	
	
	
	while ( (i<MAXITERATION) && (sortie == 0) )
		{
		//x.get(tab);
		sol.set(eq.derivs(time(),x));
		sol.mul(dt());
		sol.add(present());
		
		x.sub(sol);
		cvg =   x.norm2Sq()/sol.norm2Sq();
		
		// prepare the next iteration
		x.set(sol);
		if ( cvg < PRECISION ) 
			sortie = 1;
		i++;
		}
	
	present().set(sol);*/
	present().set(sol);	
	
	}

public String toString()
	{
	return "theta Scheme";
	}


private class func implements IFnn
	{
	//DVect tmp;
	Equation eq;
	double theta;
	public  DVect val(DVect x)
		{
		double t1=1.-theta;
		for (int i =0;i<present().size();i++)
			{
			//tmp.set(i,present().get(i));
			x.set(i,theta*present().get(i)+t1*x.get(i));
			}
		x.set(eq.derivs(time(),x));
		for (int i =0;i<present().size();i++)
			x.set(i,present().get(i) + dt()*x.get(i));
		return x;
		}
	} 
private func f =new func();

}
