package opale.ode.scheme;

import opale.mathtools.*;
import opale.ode.*;


/**
* Cette classe implmente le schma d'Euler implicite qui consiste  avancer en temps de la facon suivante : yn+1=yn+f(t,yn+1).
* @author O.C.
* @since Opale-ODE 0.11
*/
public  final class ImplicitEuler extends TimeScheme
{
/**
* This value represents the precision for the fix point method.
*/
//public static double PRECISION = 1.e-16;

/**
* This value fixes the maximum number of iterations in the algorithm.
*/ 
//public static int MAXITERATION = 100;
	
/**
* Cette mthode dfinit l'avanc en temps par la formule d'Euler implicite.
*/	
public void forward(Equation eq)
	{
	int i=0,sortie=0;
	double cvg;

	DVect sol = new DVect(present());	
	f.eq=eq;
	f.tmp = new DVect(present().size());
	
	FixPoint.solve(f,present().size(),present(), sol);
	
	//initialisation des conditions initiales
/*	DVect x = new DVect(present());	
	DVect sol = new DVect(present());	
	
	
	
	while ( (i<MAXITERATION) && (sortie == 0) )
		{
		//x.get(tab);
		sol.set(eq.derivs(time(),x));
		sol.mul(dt());
		sol.add(present());
		
		x.sub(sol);
		cvg =   x.norm2Sq()/sol.norm2Sq();
		
		// prepare the next iteration
		x.set(sol);
		if ( cvg < PRECISION ) 
			sortie = 1;
		i++;
		}
	
	present().set(sol);*/
	present().set(sol);	
	
	}

public String toString()
	{
	return "Implicit Euler";
	}


private class func implements IFnn
	{
	DVect tmp;
	Equation eq;
	
	public  DVect val(DVect x)
		{
		tmp.set(present());
		tmp.acc(dt(),eq.derivs(time(),x));
		return tmp;
		}
	} 
private func f =new func();

}
