/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/
package opale.ode;

import opale.mathtools.*;
import opale.tools.*;
import java.io.*;

/**
* This class inherites from StepSizeControl class and defines a step control. If the solution is bracketed between two values then it's ok, else the time step is divided by a number (2 by default).
* @since Opale-ODE 0.12
* @author O.C.
*/
public final class StepControl1 extends StepsizeControl
{
private double ymin, ymax, d;

/**
* 
*/
public StepControl1()
	{
	super();
	}
	
public StepControl1(TimeScheme ts)
	{
	super(ts);
	ymin = 0.;
	ymax = 1.;
	d = 2.;
	}
	
public StepControl1(double ymin, double ymax, double r)
	{
	if (r<0) throw new IllegalArgumentException("The factor of step correction must be positive.");
	this.ymin = ymin;
	this.ymax = ymax;
	this.d = r;
	}
	
/**
* Upadte the step according to the value of the solution. 
*/
public final boolean update() 
	{
	DVect sol = getTS().present();
	for (int i=0;i<sol.size();i++)
		if (sol.get(i) > ymax || sol.get(i) < ymin )
			{
			 getTS().dt(getTS().dt()/d);
			 return false;
			 }
	return true;
	}
	
public int readKeyWord(String word,RFile f,ODE ode)   throws java.io.IOException, MalformedFileException
	 {
	 int type,i;
	 if ( word.equals("ymin"))
		 {
		 type = f.nextToken();
		 if (type != StreamTokenizer.TT_NUMBER) return -1;
		 ymin = f.nval;
		 return 0;
		 }
	 else if ( word.equals("ymax"))
		 {
		 type = f.nextToken();
		 if (type != StreamTokenizer.TT_NUMBER) return -1;
		 ymax =  f.nval;
		 return 0;
		 }
	 else if ( word.equals("ratio"))
		 {
		 type = f.nextToken();
		 if (type != StreamTokenizer.TT_NUMBER) return -1;
		 d = f.nval;
		 return 0;
		 }
	 return -1;
	 }


 public void writeFile(WFile f, ODE ode)
	 {
	 f.writeln("{");
	 f.writeln("ymin "+ymin);
	 f.writeln("ymax "+ymax);
	 f.writeln("ratio "+d);
	 f.writeln("}");
	 }
}
