package opale.ode;

import opale.tools.*;
import java.io.*;


/**
* Abstract class to dfine an object in the family 'ODE'. To inherite of this class implies the definition of  methods to read/write the current object in a '*.ode' file. See Opale ODE documentation for description of this file format.
* @author O.C.
* @since Opale-ODE 0.1
*/ 
public abstract class ObjectODE 
{
/**
* This method read the data in a file at format '.ode' . It calls the abstract method <code>readKeyword</code> implemented in the derivated classes.
* @param RFile f, file to read.
* @param ODE od, the group of object that are read in the file.
*/
public void readFile( RFile f,ODE ode) throws java.io.IOException,MalformedFileException
	{
	int type;
	type = f.nextToken();	//on lit la premiere '{'
	if ( (type !=StreamTokenizer.TT_WORD) || !f.sval.equals("{") ) throw new MalformedFileException("Fichier de donnes au mauvais format !!");
	type = f.nextToken();	
	do
		{
		if (type != StreamTokenizer.TT_WORD)  throw new MalformedFileException("Fichier de donnes au mauvais format : on attend un mot cl !!");
		if (readKeyWord(f.sval,f,ode) == -1) throw new MalformedFileException("Fichier de donnes au mauvais format : erreur de lecture d'un mot cl !!");
		type = f.nextToken();
		}
	while ((type !=StreamTokenizer.TT_WORD) || !f.sval.equals("}") );
	
	}
	
/**
* Abstracct method to read a key word in a file '*.ode'.
* @param String s, key word to read.
* @param RFile f, file to read.
* @param ODE ode,  the group of 'ODE' object
* @return int, 0 if the key word is correct, -1 otherwise.
*/
public abstract int readKeyWord(String s, RFile f,ODE ode) throws java.io.IOException, MalformedFileException; 

/**
* Abstrcat method to write the current object in a file..
* @param WFile f, file to write.
* @param ODE ode,   the set of 'ODE' object. 
*/
public abstract void writeFile(WFile f, ODE ode) throws MalformedFileException;
}
