/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.matrix.solver;

import opale.tools.Debug;
import opale.mathtools.DVect;
import opale.matrix.*;

/**
* This class implements LU decomposition (without pivoting!!) for the band matrices.
* @author O.C.
* @date 07/2001
*/


public class SolverLUBand implements Solver, BandDecomposition
{

private BandMatrix MatLU;
private int[] pivot;
private int signepermut;


public void decomp(BandMatrix A)
	{
	//if (A.getRowDim() != A.getColumnDim() ) throw new IllegalArgumentException("LU decomposition implemented only for square matrix");
	int n = A.getSize();
	int  jmax,tmp,max,min;
	double Amax,pivinv;
	int lb = (A.getSizeOfBand()-1)/2;
	pivot = new int[n];
	signepermut=1;
	
	
	double[] LU;
	if (BandDecomposition.REPLACE)  MatLU = A;
	else MatLU=A.copy();
	LU = MatLU.getInternalArray();
	//LU[A.getPosition(2,1) ] = 34;
	for (int i=0;i<n;i++)
		pivot[i] = i;
		
	for (int k=0;k<n-1;k++)
		{
		Amax = Math.abs(LU[A.getPosition(pivot[k],k)]);
		jmax = k;
		min = Math.max(0,k-lb);
		max = Math.min(n-1,k+lb);

/*Debug.print(k);		
Debug.print(max);	*/	

// Pour l'instant pas de pivot partiel.
/*		for (int i=k+1;i<=max;i++)
			{
			if (Math.abs( LU[A.getPosition(pivot[i],k)] ) > Amax )
				{
				Amax = Math.abs(LU[A.getPosition(pivot[i],k)]);
				jmax = i;
				}
			}
			
		if (jmax != k)
			{
			tmp = pivot[k];
			pivot[k] = pivot[jmax];
			pivot[jmax]=tmp;
			signepermut=-signepermut;
			}*/
		pivinv = 1./LU[A.getPosition(pivot[k],k)];

/*Debug.print(jmax);*/		
		
		max = Math.min(n-1,pivot[k]+lb);
		for (int i=k+1;i<=max;i++)
			{
/*Debug.print(" i "+i);	*/	
			//min = Math.max(0,pivot[i]-lb);
			//imax = Math.min(n-1,pivot[i]+lb);
			double c = LU[A.getPosition(pivot[i],k)]*pivinv;
			LU[A.getPosition(pivot[i],k)] = c;
			
			for(int j=k+1;j<=max;j++)
				LU[A.getPosition(pivot[i],j)] = LU[A.getPosition(pivot[i],j)] - c*LU[A.getPosition(pivot[k],j)];
			}
		}
	}

/** 
* Compute the determinant : product of U[i][i]
* @return     double, the determinant
*/
public double determinant() 
	{
	double det = (int) signepermut;
	int band = MatLU.getSizeOfBand();
	int n = MatLU.getSize();
	double[] LU =  MatLU.getInternalArray();
	for (int i = 0; i < n; i++) 
		det *= LU[i*band+(band-1)/2];

	return det;
	}
			

/**
* Solve LUx=b.
* @param Matrix A, not used.
*/
public void solve(Matrix A,DVect b, DVect x)
	{
	int n = MatLU.getSize(),im;
	double[] LU =  MatLU.getInternalArray();
	int lb = (MatLU.getSizeOfBand()-1)/2;
	
	if ((n != b.size()) || (n != x.size())) throw new IllegalArgumentException("matrix and vector dimension are not equals.");
	
	double[] B = b.toArray();
	double[] X = x.toArray();
	
	
	for (int i=0;i<n;i++)
		{
		double c=0.;
		im = Math.max(0,i-lb);
		for (int j=im;j<i;j++)
			c+=LU[MatLU.getPosition(pivot[i],j)]*X[j];
		X[i] = B[pivot[i]]-c;
		}
	
	for (int i=n-1;i>=0;i--)
		{
		double c=0.;
		im = Math.min(n-1,i+lb);
		for (int j=i+1;j<=im;j++)
			c+=LU[MatLU.getPosition(pivot[i],j)]*X[j];
		X[i] = (X[i]-c)/LU[MatLU.getPosition(pivot[i],i)];
		}
		
	}
	

public static void main(String[] arg)
	{
	int size = 6;
	BandMatrix A = new BandMatrix (size,3);

	for (int i=0;i<size;i++)
		{
		A.set(i,i,2);
		if (i>0) A.set(i,i-1,-7);
		if (i<size-1) A.set(i,i+1,-1);
		 }
	System.out.println(A);
	//System.out.println(A.get(2,2));
	
	DVect b=new DVect(6);
	DVect x=new DVect(6);

	
	b.set(0,1);
	b.set(1,0);
	
	
	SolverLUBand lu = new SolverLUBand();
	lu.decomp(A);
	System.out.println(A);
	System.out.println("det = " +lu.determinant());
	lu.solve(null,b,x);
		

	
	System.out.println(x);
	}
	
			
}
	
	

