package opale.matrix;
/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


import opale.mathtools.DVect;
import opale.matrix.*;

/** 
* This interface must be implemented by classes that define decomposition method, for instance LU, Cholesky... A class can be implemented both <code>Solver</code> and <code>Decomposition</code>.
* @author O.C.
* @date 04/2001
*/

public interface Decomposition
{
/**
* Set to true to indicate the algorithm modify the input matrix in the method <code>decomp()</code>.
*/
static final boolean REPLACE=true;



/**
* Decompose the matrix A.
*/
public void decomp(Matrix A);
}

