/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.tools.*;
import opale.mathtools.*;
import opale.m2d.*;
import java.util.Vector;
import java.io.StreamTokenizer;
/**
* Cette classe reprsente une fonction y =f(x).
* @since Opale-2d 0.1
* @author O.C.
*/

public class yFx extends Object2D implements Cloneable
{
private IyFx fonc;
private String sf="";
private boolean fromString=false;
private ParseFunction parser;
private OIJ oij;
protected double xinf, xsup;
protected int N;

/**
* Constructeur par dfaut.
*/
public yFx()
	{
	super();
	oij=new OIJ();
	if (Debug.On) Debug.print("Dans yFx()");
	parser = new ParseFunction();
	N=100;
	xinf =0;
	xsup = 10;
        fonc = new IyFx() { public double val(double x) {return 0;}};	
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
*/
public yFx(OIJ rep)
	{
	super(rep);
	oij =  rep;
	parser = new ParseFunction();
	N=100;
	xinf =0;
	xsup = 10;
        fonc = new IyFx() { public double val(double x) {return 0;}};	
	}


/**
* Le constructeur de copie
* @param yFx d, l'objet  copier.
*/
public yFx(yFx f)
	{
        super(f.getOIJ());
	oij = f.oij;
	fromString = f.fromString;
	if ( fromString )
		{
		sf = f.sf;
		parser = new ParseFunction();
		if (!parser.parse(sf))
			{
			System.err.println("Problme dans yFx(yFx f) : Ne devrait jamais arriver !!");
			System.exit(-1);
			}
		}
	else
		fonc=f.fonc;
	N = f.N;
	xinf=f.xinf;
	xsup=f.xsup;
	}

/**
* Renvoie la valeur de la fonction en un point.
* @aparam double x, le point  calculer.
*/
public double val(double x)
	{
	Matrix2D mv = new Matrix2D();
	oij.matPassage(getOIJ(),mv);
	double[] p = mv.compute(x,0);
	x = p[0];
	if ( fromString)
		{
		try
		{
		double resu = parser.getResult(x);
		getOIJ().matPassage(oij,mv);
		p = mv.compute(x,resu);
		return p[1];
		}
		catch (Exception e)
		{
		System.err.println(e);
		System.err.println("Ne devrait jamais arriver");
		}
		return 0;
		}
	else
		{
		double resu = fonc.val(x);
		getOIJ().matPassage(oij,mv);
		p = mv.compute(x,resu);
		return p[1];
		}
	}

/**
* Fixe la fonction a tracer, les bornes de dfinition et le nombre de points.
* @param IyFx f, la fonction  dessiner.
* @param double xinf, xsup, les bornes du domaine de dfinition.
* @param int n, le nombre de points  considerer sur la courbe.
* @deprecated
*/
public void set(IyFx f, double inf, double sup, int n)
	{
	N = Math.max(2,n); 
	fromString = false;
	fonc = f;
	if ( inf > sup )
		{
		xsup = inf;
		xinf = sup;
		}
	else
		{
		xsup = sup;
		xinf = inf;
		}
	}
/**
* Fixe la fonction a tracer, les bornes de dfinition et le nombre de points.
* @param IyFx f, la fonction  dessiner.
* @param String s, l'expression de f sous forme de chaine.
* @param double xinf, xsup, les bornes du domaine de dfinition.
* @param int n, le nombre de points  considerer sur la courbe.
*/
public void set(IyFx f, String s, double inf, double sup, int n)
	{
	sf = s;
	N = Math.max(2,n); 
	fromString = false;
	fonc = f;
	if ( inf > sup )
		{
		xsup = inf;
		xinf = sup;
		}
	else
		{
		xsup = sup;
		xinf = inf;
		}
	}
/**
* Fixe les bornes de dfinition.
* @param double xinf, xsup, les bornes du domaine de dfinition.
*/
public void set(double inf, double sup)
	{
	if ( inf > sup )
		{
		xsup = inf;
		xinf = sup;
		}
	else
		{
		xsup = sup;
		xinf = inf;
		}
	}
/**
* Fixe le nombre de points de prcision.
* @param int n, le nombre de points.
*/
public void set(int n)
	{
	N = Math.max(2,n); 
	}
	
/**
* Fixe la fonction a tracer.
* @param IyFx f, la fonction  dessiner.
* @deprecated
*/
public void set(IyFx f)
	{
	fromString = false;
	fonc = f;
	}
	
/**
* Fixe la fonction a tracer et son expression
* @param IyFx f, la fonction  dessiner.
* @param String s, l'expression de f sous forme de chaine.
* @deprecated
*/
public void set(IyFx f, String s)
	{
	sf = s;
	fromString = false;
	fonc = f;
	}

/**
* Fixe la fonction a tracer  partir d'une chaine de caractres.
* @param String s, la chaine de caractre reprsentant la fonction  dessiner.
* @return boolean, true si la chaine a pu etre interprt coorectement.
*/
public boolean set(String s)
	{
	if (parser.parse(s))
		{
		boolean[] b = parser.getVariables();
		if ( b[1] || b[2] )
			return false;
		fromString = true;
		sf = s;
		return true;
		}
	return false;
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	yFx y = (yFx) super.clone();
	y.oij = oij;
	y.parser = new ParseFunction();
	if (fromString)
		y.parser.parse(sf);
	return y;
	}

/**
* Effectue un changement de repere de l'objet. Pas encore disponible
* @param OIJ rep, le nouveau repere.
*/
public void changeOIJ(OIJ rep)
	{
	oij=rep;
	}
	
public void writeFileMore(WFile f, Pack2D p)
	{
	int i;
	f.writeln("N "+N);
	f.writeln("Xinf "+xinf);
	f.writeln("Xsup "+xsup);
	f.writeln("f(x)=  '"+sf+"'");
	
	}	
	
public int readKeyWord(String word, RFile f, Pack2D p)  throws java.io.IOException, MalformedFileException
	{
	int type,i;
	if ( word.equals("N"))
		{
		type = f.nextToken();
		N = (int) f.nval;
		return 0;
		}
	else if ( word.equals("f(x)="))
		{
		type = f.nextToken();
	//System.out.println("mot = " + f.sval);
		if (!( f.sval.endsWith("'") && f.sval.startsWith("'")))  throw new MalformedFileException("Erreur  la lecture de la fonction  tracer : "+f.sval+". La fonction  tracer doit etre indiqu entre guillemets");
		String s = f.sval.substring(1,f.sval.length()-1);
		if ( !set(s) ) throw new MalformedFileException("Erreur  la lecture de la fonction  tracer : "+s);
		return 0;
		}
	else if ( word.equals("Xinf"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		xinf = f.nval;
		return 0;
		}
	else if ( word.equals("Xsup"))
		{
		type = f.nextToken();
		if (type != StreamTokenizer.TT_NUMBER) return -1;
		xsup = f.nval;
		return 0;
		}
	return -1;
		
	}
	
public String toString()
	{
	String s="f(x) = "+sf;
	return s;
	}
	
public static void main(String[] arg)
	{
	OIJ rep = new OIJ();
	yFx f = new yFx(rep);
	try
	{
	OIJ rep2 = new OIJ(rep,1,0,1,0,0,1);
	f.changeOIJ(rep2);
	f.set(new IyFx() { public double val(double x) {return (x-1)*(x-1);}},"(x-1)*(x-1)");
	System.err.println(f.val(0));
	System.err.println(0.01-0.1*0.1);
	}
	catch(OIJException e)
	{}
	}	
}
