package opale.module2d.objet2d;
import opale.module2d.noyau2d.*;

/**
* Cette classe modlise un polygone et implmente l'interface <code>Transformable</code>.
* @version 0.1
* @author O.C.
*/

public class Polygon implements Transformable
{
protected int nbPoint;
protected Point2D[] sommets;

/**
* Constructeur avec nb de Sommets et liste des sommets.
* @param int n, le nombre de sommets.
* @param Point2D[] p, la liste des sommets.
*/

public Polygon(int n,Point2D[] p)
{
nbPoint=n;
sommets = new Point2D[n];

for (n=0;n<nbPoint;n++)
  sommets[n]=new Point2D(p[n]);
}



//les methodes de l'interface Transformable

public void translate(double dx,double dy)
	{
	int i;

	for (i=0;i<nbPoint;i++)
	  sommets[i].translate(dx,dy);
	}

public void translate(Vector2D v)
	{
	translate(v.x,v.y);
	}

public void rotate(double theta)
	{
	int i;

	for (i=0;i<nbPoint;i++)
	  sommets[i].rotate(theta);
	}

public void rotate(Point2D A,double theta)
	{
	this.translate(-A.x,-A.y);
	this.rotate(theta);
	this.translate(A.x,A.y);
	}




}