/*
Copyright (C) 2000  Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.object2d;
import opale.tools.*;
import opale.mathtools.*;
import opale.m2d.ker.*;
import java.util.Vector;


/**
* This class represents a fractal generated by a motif and affines transformations.
* @author O.C.
* @since Opale-2d 0.12
* @date 02/2001
*/
public class Fractal extends Object2D  implements GObject2D
{
private InfoObject info; 
protected int ntransf;	// number of transformations
protected int NITER;	// number of iterations
protected AffineTransform2D[] transf; // the transformation
/**
* Constructor by default.
* @since Opale-2d 0.12
*/
public Fractal()
	{
	super();
	NITER = 5;
	ntransf = 1;
	System.out.println("Dans Fractal()" + ntransf);
	transf = new AffineTransform2D[1];
	transf[0] = new AffineTransform2D();	// the identity
	info = new InfoObject();
	}

/**
* Initialise l'objet avec 0 points et un repre OIJ donn.
* @param OIJ rep, le repre.
*/
/*public Data2D(OIJ rep)
        {
        super(rep);
	x = new double[1];
	y = new double[1];
        }*/

/**
* Initialise l'objet avec n points et un repre OIJ donn.
* @param OIJ rep, le repre.
* @param int n, le nombre de points
*/
/*public Data2D(OIJ rep, int n)
        {
        super(rep);
	nbPts = Math.abs(n);
	x = new double[nbPts];
	y = new double[nbPts];
        }*/

/**
* Le constructeur de copie.
* @param Data2D le nuage  copier.
*/
/*public Data2D(Data2D d)
        {
        super(d.getOIJ());
	int i;
	
        this.nbPts = d.nbPts;
	x = new double[nbPts];
	y = new double[nbPts];
	
	for (i=0;i<nbPts;i++)
		{
		x[i] = d.x[i];
		y[i] = d.y[i];
		}
	}*/
	
public void writeFileMore(WFile f, Pack2D p)
	{
	}	
	
public int readKeyWord(String word, RFile f, Pack2D p)  throws java.io.IOException, MalformedFileException
	{
	return 0;
	}


private void drawFractal(double x, double y,Pen2D c, int it)
	{
	if (it!= NITER)
	{
	c.drawPoint(x,y);
	drawFractal(x/3,y/3,c,it+1);
drawFractal(x/3+1./3,y/3,c,it+1);
drawFractal(x/3+2./3,y/3,c,it+1);
drawFractal(x/3,y/3+1./3,c,it+1);
drawFractal(x/3,y/3+2./3,c,it+1);
drawFractal(x/3+1./3,y/3+2./3,c,it+1);
drawFractal(x/3+2./3,y/3+1./3,c,it+1);
drawFractal(x/3+2./3,y/3+2./3,c,it+1);
}
	} 

public void draw(Pen2D c)
	{
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
		drawFractal(.5,.5,c,0);
		}
	}

public InfoObject getInfo()
	{
	return info;
	}
	


/**
* Effectue un changement de repere de l'objet.
* @param OIJ rep, le nouveau repere.
*/
public void changeOIJ(OIJ rep)
	{
	}
	

public String toString()
	{
	String s="Fractal";
	return s;
	}
	
	public static void main(String[] arg) 		{
		opale.m2d.component2d.JFrame2D jf = new opale.m2d.component2d.JFrame2D();
		Fractal fr = new Fractal();
		
		jf.getPack2D().add(fr,"fract");
		
		jf.show();
		}



}
