/*
Copyright (C) 2000  Groupe Opale

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.object2d;
import opale.module2d.noyau2d.*;
import opale.tools.*;
import opale.mathtools.*;

/**
* Cette classe tend <code>Object2D</code> et reprsente une fonction y =a*exp(bx)+c.
* @version 0.11
* @author O.C.
*/

public class Exp extends Object2D implements Cloneable
{
protected double a,b,c;
protected double tinf, tsup;
protected int N;

/**
* Constructeur par dfaut.
* @since Opale 0.11
*/
public Exp()
	{
	super();
	System.out.println("Dans Exp()");
	a = b =1;
	c = 0;
	N=100;
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
* @since Opale 0.11
*/
public Exp(OIJ rep)
	{
	super(rep);
	a = b =1;
	c = 0;
	N=100;
	}

/**
* Construit et initialise une instance avec les paramtres a et b..  
* @param OIJ rep, le repre.
* @since Opale 0.11
*/
public Exp(OIJ rep, double a, double b,double c)
	{
	super(rep);
	this.a = a;
	this.b = b;
	this.c = c;
	N=100;
	}

/**
* Le constructeur de copie
* @param Exp d, l'objet  copier.
* @since Opale 0.11
*/
public Exp(Exp f)
	{
	super(f);
	a = f.a;
	b = f.b;
	c = f.c;
	N = f.N;
	}

/**
* Fixe les paramtres a et b de l'equation y = a *exp(bx)+c.
* @param double a, b, c les paramtres a et b et c.
* @since Opale 0.11
*/
public void set(double a, double b,double c)
	{
	this.a = a;
	this.b = b;
	this.c = c;
	}

/**
* Fixe la prcision du trac.
* @param int n, lle nombre du points  afficher.
* @since Opale 0.11
*/
public void set(int n)
	{
	N = n;
	}
	

/**
* Fixe les bornes de dfinition et le nombre de points.
* @param double xinf, xsup, les bornes du domaine de dfinition.
* @param int n, le nombre de points  considerer sur la courbe.
* @since Opale 0.11
*/
public void set(double inf, double sup, int n)
	{
	N = Math.max(2,n); 
	
	if ( inf > sup )
		{
		double xsup = sup;
		sup = inf;
		inf = xsup;
		}
		
	x = new double[nbPts];
	y = new double[nbPts];
	int i;
	double pas = Math.abs(sup-inf)/(nbPts-1);
	
	for (i=0;i<nbPts;i++)
		{
		x[i] = inf + i*pas;
		y[i] = a*Math.exp(x[i]*b)+c;
		}
	}
	

	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.11
*/
public Object clone()
	{
	Exp gy = (Exp) super.clone();
	return gy;
	}

}
