/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import opale.mathtools.DVect;
import opale.ode.Equation;
import opale.ode.NoStepsizeControl;
import opale.ode.ODE;
import opale.ode.ObjectODE;
import opale.ode.Problem;
import opale.ode.StepsizeControl;
import opale.tools.MalformedFileException;
import opale.tools.RFile;
import opale.tools.WFile;

public abstract class TimeScheme
extends ObjectODE {
    private double tinit = 0.0;
    private double tmax = 1.0;
    private double tc;
    private double dtmax = 1.0E9;
    private double dtmin = 0.0;
    private double dt;
    private int Nstep = 11;
    private Problem pb = null;
    private StepsizeControl stepcontrol;
    private DVect present;
    private DVect past;

    public abstract void forward(Equation var1);

    public final DVect present() {
        return this.present;
    }

    public final void set(double d, double d2) {
        this.tinit = Math.min(d, d2);
        this.tmax = Math.max(d, d2);
    }

    public final void setNstep(int n) {
        this.Nstep = Math.max(3, Math.abs(n));
    }

    public final int getNstep() {
        return this.Nstep;
    }

    public final void setPb(Problem problem) {
        this.pb = problem;
    }

    public final Problem getPb() {
        return this.pb;
    }

    public final void setStepsizeControl(StepsizeControl stepsizeControl) {
        this.stepcontrol = stepsizeControl;
    }

    public final double tmin() {
        return this.tinit;
    }

    public final double tmax() {
        return this.tmax;
    }

    public final double dtmax() {
        return this.dtmax;
    }

    public final double dtmin() {
        return this.dtmin;
    }

    public final void dtmax(double d) {
        this.dtmax = d;
    }

    public final void dtmin(double d) {
        this.dtmin = d;
    }

    public final double dt() {
        return this.dt;
    }

    public final void dt(double d) {
        this.dt = d;
    }

    public final double time() {
        return this.tc;
    }

    public void init() {
        if (this.pb == null) {
            System.err.println("No problem for this scheme !.\nStop.");
            System.exit(-1);
        }
        if (this.stepcontrol == null) {
            this.stepcontrol = new NoStepsizeControl(this);
        } else {
            this.stepcontrol.setTS(this);
        }
        this.present = new DVect(this.pb.dim());
        this.past = new DVect(this.pb.dim());
        this.present.set(this.pb.getInit());
        this.past.set(this.pb.getInit());
        this.dt = (this.tmax - this.tinit) / (double)(this.Nstep - 1);
        if (this.dt < this.dtmin) {
            this.dt = this.dtmin;
        } else if (this.dt > this.dtmax) {
            this.dt = this.dtmax;
        }
        this.tc = this.tinit;
    }

    public boolean update() {
        if (this.stepcontrol.update()) {
            this.tc += this.dt;
            this.past.set(this.present);
            return true;
        }
        this.present.set(this.past);
        return false;
    }

    public int readKeyWord(String string, RFile rFile, ODE oDE) throws IOException, MalformedFileException {
        if (string.equals("N")) {
            int n = rFile.nextToken();
            this.Nstep = (int)rFile.nval;
            return 0;
        }
        if (string.equals("tmin")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.tinit = rFile.nval;
            return 0;
        }
        if (string.equals("tmax")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.tmax = rFile.nval;
            return 0;
        }
        if (string.equals("stepcontrol")) {
            int n = rFile.nextToken();
            if (n != -3) {
                throw new MalformedFileException("Incorrect data file : Error reading a stepcontrol method in a time scheme ");
            }
            if (!oDE.contains(rFile.sval) || oDE.fromId(rFile.sval) == null) {
                throw new MalformedFileException("Incorrect data file : indentifier " + rFile.sval + " doesn't exist !!");
            }
            if (!(oDE.fromId(rFile.sval) instanceof StepsizeControl)) {
                throw new MalformedFileException("Incorrect data file : indentifier " + rFile.sval + " is not a step control method !!");
            }
            this.stepcontrol = (StepsizeControl)oDE.fromId(rFile.sval);
            return 0;
        }
        return -1;
    }

    public void writeFile(WFile wFile, ODE oDE) {
        wFile.writeln("{");
        wFile.writeln("tmin " + this.tinit);
        wFile.writeln("tmax " + this.tmax);
        wFile.writeln("N " + this.Nstep);
        wFile.writeln("StepControl " + oDE.getId(this.stepcontrol));
        wFile.writeln("}");
    }
}

