/*
 * Decompiled with CFR 0.152.
 */
package opale.ode;

import java.io.IOException;
import opale.mathtools.DVect;
import opale.ode.ODE;
import opale.ode.StepsizeControl;
import opale.ode.TimeScheme;
import opale.tools.MalformedFileException;
import opale.tools.RFile;
import opale.tools.WFile;

public final class StepControl1
extends StepsizeControl {
    private double ymin;
    private double ymax;
    private double d;

    public StepControl1() {
    }

    public StepControl1(TimeScheme timeScheme) {
        super(timeScheme);
        this.ymin = 0.0;
        this.ymax = 1.0;
        this.d = 2.0;
    }

    public StepControl1(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new IllegalArgumentException("The factor of step correction must be positive.");
        }
        this.ymin = d;
        this.ymax = d2;
        this.d = d3;
    }

    public final boolean update() {
        DVect dVect = this.getTS().present();
        int n = 0;
        while (n < dVect.size()) {
            if (dVect.get(n) > this.ymax || dVect.get(n) < this.ymin) {
                this.getTS().dt(this.getTS().dt() / this.d);
                return false;
            }
            ++n;
        }
        return true;
    }

    public int readKeyWord(String string, RFile rFile, ODE oDE) throws IOException, MalformedFileException {
        if (string.equals("ymin")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.ymin = rFile.nval;
            return 0;
        }
        if (string.equals("ymax")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.ymax = rFile.nval;
            return 0;
        }
        if (string.equals("ratio")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.d = rFile.nval;
            return 0;
        }
        return -1;
    }

    public void writeFile(WFile wFile, ODE oDE) {
        wFile.writeln("{");
        wFile.writeln("ymin " + this.ymin);
        wFile.writeln("ymax " + this.ymax);
        wFile.writeln("ratio " + this.d);
        wFile.writeln("}");
    }
}

