/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.object2d;

import java.io.IOException;
import java.util.Vector;
import opale.m2d.AffineTransform2D;
import opale.m2d.Matrix2D;
import opale.m2d.OIJ;
import opale.m2d.Object2D;
import opale.m2d.Pack2D;
import opale.m2d.Transformable;
import opale.m2d.object2d.Line2D;
import opale.m2d.object2d.LineException;
import opale.mathtools.IxyFt;
import opale.mathtools.IyFx;
import opale.tools.MalformedFileException;
import opale.tools.RFile;
import opale.tools.WFile;

public class Data2D
extends Object2D
implements Transformable,
Cloneable {
    protected double[] x;
    protected double[] y;
    protected int nbPts;

    public Data2D() {
        System.out.println("Dans Data2D()" + this.nbPts);
        this.x = new double[1];
        this.y = new double[1];
    }

    public Data2D(OIJ oIJ) {
        super(oIJ);
        this.x = new double[1];
        this.y = new double[1];
    }

    public Data2D(OIJ oIJ, int n) {
        super(oIJ);
        this.nbPts = Math.abs(n);
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
    }

    public Data2D(Data2D data2D) {
        super(data2D.getOIJ());
        this.nbPts = data2D.nbPts;
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
        int n = 0;
        while (n < this.nbPts) {
            this.x[n] = data2D.x[n];
            this.y[n] = data2D.y[n];
            ++n;
        }
    }

    public void set(int n, double[] dArray, double[] dArray2) {
        this.nbPts = n;
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
        int n2 = 0;
        while (n2 < this.nbPts) {
            this.x[n2] = dArray[n2];
            this.y[n2] = dArray2[n2];
            ++n2;
        }
    }

    public void add(double d, double d2) {
        double[] dArray = new double[this.nbPts];
        double[] dArray2 = new double[this.nbPts];
        int n = 0;
        while (n < this.nbPts) {
            dArray[n] = this.x[n];
            dArray2[n] = this.y[n];
            ++n;
        }
        this.x = new double[++this.nbPts];
        this.y = new double[this.nbPts];
        n = 0;
        while (n < this.nbPts - 1) {
            this.x[n] = dArray[n];
            this.y[n] = dArray2[n];
            ++n;
        }
        this.x[this.nbPts] = d;
        this.y[this.nbPts] = d2;
    }

    public void writeFileMore(WFile wFile, Pack2D pack2D) {
        wFile.writeln("N " + this.nbPts);
        wFile.writeln("Points ");
        int n = 0;
        while (n < this.nbPts) {
            wFile.writeln(this.x[n] + " " + this.y[n]);
            ++n;
        }
    }

    public int readKeyWord(String string, RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        if (string.equals("N")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.nbPts = (int)rFile.nval;
            this.x = new double[this.nbPts];
            this.y = new double[this.nbPts];
            return 0;
        }
        if (string.equals("Points")) {
            int n = 0;
            while (n < this.nbPts) {
                int n2 = rFile.nextToken();
                if (n2 != -2) {
                    return -1;
                }
                this.x[n] = rFile.nval;
                n2 = rFile.nextToken();
                if (n2 != -2) {
                    return -1;
                }
                this.y[n] = rFile.nval;
                ++n;
            }
            return 0;
        }
        return -1;
    }

    public void set(IyFx iyFx, double d, double d2, int n) {
        this.nbPts = Math.max(2, n);
        if (d > d2) {
            double d3 = d2;
            d2 = d;
            d = d3;
        }
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
        double d4 = Math.abs(d2 - d) / (double)(this.nbPts - 1);
        int n2 = 0;
        while (n2 < this.nbPts) {
            this.x[n2] = d + (double)n2 * d4;
            this.y[n2] = iyFx.val(this.x[n2]);
            ++n2;
        }
    }

    public void set(IxyFt ixyFt, double d, double d2, int n) {
        double d3;
        this.nbPts = Math.max(2, n);
        if (d > d2) {
            d3 = d2;
            d2 = d;
            d = d3;
        }
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
        double d4 = Math.abs(d2 - d) / (double)(this.nbPts - 1);
        int n2 = 0;
        while (n2 < this.nbPts) {
            d3 = d + (double)n2 * d4;
            this.x[n2] = ixyFt.x(d3);
            this.y[n2] = ixyFt.y(d3);
            ++n2;
        }
    }

    public void readData(RFile rFile) throws IOException {
        Vector<Double> vector = new Vector<Double>(100, 20);
        Vector<Double> vector2 = new Vector<Double>(100, 20);
        int n = rFile.nextToken();
        while (n != -1) {
            if (n == -2) {
                vector.add(new Double(rFile.nval));
            }
            if ((n = rFile.nextToken()) == -2) {
                // empty if block
            }
            vector2.add(new Double(rFile.nval));
            n = rFile.nextToken();
        }
        this.nbPts = vector.size();
        this.x = new double[this.nbPts];
        this.y = new double[this.nbPts];
        Object[] objectArray = new Double[this.nbPts];
        Object[] objectArray2 = new Double[this.nbPts];
        vector.copyInto(objectArray);
        vector2.copyInto(objectArray2);
        int n2 = 0;
        while (n2 < this.nbPts) {
            this.x[n2] = (Double)objectArray[n2];
            this.y[n2] = (Double)objectArray2[n2];
            ++n2;
        }
    }

    public void translate(double d, double d2) {
        int n = 0;
        while (n < this.nbPts) {
            int n2 = n;
            this.x[n2] = this.x[n2] + d;
            int n3 = n++;
            this.y[n3] = this.y[n3] + d2;
        }
    }

    public void rotate(double d) {
        double d2 = Math.cos(d);
        double d3 = Math.sin(d);
        int n = 0;
        while (n < this.nbPts) {
            double d4 = this.x[n];
            this.x[n] = d4 * d2 - this.y[n] * d3;
            this.y[n] = d4 * d3 + this.y[n] * d2;
            ++n;
        }
    }

    public void rotate(double d, double d2, double d3) {
        this.translate(-d, -d2);
        this.rotate(d3);
        this.translate(d, d2);
    }

    public void transform(AffineTransform2D affineTransform2D) {
        affineTransform2D.transform(this.x, this.y, this.x, this.y, this.nbPts);
    }

    public void changeOIJ(OIJ oIJ) {
        Matrix2D matrix2D = new Matrix2D();
        this.getOIJ().matPassage(oIJ, matrix2D);
        int n = 0;
        while (n < this.nbPts) {
            double[] dArray = matrix2D.compute(this.x[n], this.y[n]);
            this.x[n] = dArray[0];
            this.y[n] = dArray[1];
            ++n;
        }
        this.setOIJ(oIJ);
    }

    public Object clone() {
        Data2D data2D = (Data2D)super.clone();
        data2D.x = new double[this.nbPts];
        data2D.y = new double[this.nbPts];
        int n = 0;
        while (n < this.nbPts) {
            data2D.x[n] = this.x[n];
            data2D.y[n] = this.y[n];
            ++n;
        }
        return data2D;
    }

    public boolean equals(Object object) {
        if (object instanceof Data2D) {
            Data2D data2D = (Data2D)object;
            boolean bl = false;
            bl = this.nbPts == data2D.nbPts;
            if (bl) {
                int n = 0;
                while (n < this.nbPts) {
                    bl = bl && this.x[n] == data2D.x[n] && this.y[n] == data2D.y[n];
                    ++n;
                }
            }
            return bl && this.getOIJ().equals(data2D.getOIJ());
        }
        return false;
    }

    public String toString() {
        String string = "Data2D";
        return string;
    }

    public Data2D forwardDiff() {
        Data2D data2D = new Data2D(this.getOIJ(), this.nbPts - 1);
        int n = 0;
        while (n < this.nbPts - 1) {
            data2D.x[n] = this.x[n];
            double d = this.x[n + 1] - this.x[n];
            if (d != 0.0) {
                data2D.y[n] = (this.y[n + 1] - this.y[n]) / d;
            }
            ++n;
        }
        return data2D;
    }

    public Data2D backwardDiff() {
        Data2D data2D = new Data2D(this.getOIJ(), this.nbPts - 1);
        int n = 1;
        while (n < this.nbPts) {
            data2D.x[n] = this.x[n];
            double d = this.x[n] - this.x[n - 1];
            if (d != 0.0) {
                data2D.y[n] = (this.y[n] - this.y[n - 1]) / d;
            }
            ++n;
        }
        return data2D;
    }

    public Data2D centeredDiff() {
        Data2D data2D = new Data2D(this.getOIJ(), this.nbPts - 1);
        int n = 1;
        while (n < this.nbPts - 1) {
            data2D.x[n] = this.x[n];
            double d = this.x[n + 1] - this.x[n - 1];
            if (d != 0.0) {
                data2D.y[n] = (this.y[n + 1] - this.y[n - 1]) / d;
            }
            ++n;
        }
        return data2D;
    }

    public double sumRectForward() {
        double d = 0.0;
        int n = 0;
        while (n < this.nbPts - 1) {
            d += this.y[n] * (this.x[n + 1] - this.x[n]);
            ++n;
        }
        return d;
    }

    public double sumRectBackward() {
        double d = 0.0;
        int n = 1;
        while (n < this.nbPts) {
            d += this.y[n] * (this.x[n] - this.x[n - 1]);
            ++n;
        }
        return d;
    }

    public double sumRectCentered() {
        double d = this.y[0] * (this.x[1] - this.x[0]) / 2.0;
        int n = 1;
        while (n < this.nbPts - 1) {
            d += this.y[n] * (this.x[n + 1] - this.x[n - 1]) / 2.0;
            ++n;
        }
        return d += this.y[this.nbPts - 1] * (this.x[this.nbPts - 1] - this.x[this.nbPts - 2]) / 2.0;
    }

    public double sumTrapez() {
        double d = 0.0;
        int n = 0;
        while (n < this.nbPts - 1) {
            d += (this.y[n] + this.y[n + 1]) / 2.0 * (this.x[n + 1] - this.x[n]);
            ++n;
        }
        return d;
    }

    public double[] regLin() {
        double[] dArray = new double[2];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < this.nbPts) {
            d += this.x[n];
            d2 += this.y[n];
            d3 += this.x[n] * this.y[n];
            d4 += this.x[n] * this.x[n];
            ++n;
        }
        double d5 = ((double)this.nbPts * d3 - d * d2) / ((double)this.nbPts * d4 - d * d);
        double d6 = (d2 * d4 - d3 * d) / ((double)this.nbPts * d4 - d * d);
        dArray[0] = d5;
        dArray[1] = d6;
        return dArray;
    }

    public Line2D regLinear() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        int n = 0;
        while (n < this.nbPts) {
            d += this.x[n];
            d2 += this.y[n];
            d3 += this.x[n] * this.y[n];
            d4 += this.x[n] * this.x[n];
            ++n;
        }
        double d5 = ((double)this.nbPts * d3 - d * d2) / ((double)this.nbPts * d4 - d * d);
        double d6 = (d2 * d4 - d3 * d) / ((double)this.nbPts * d4 - d * d);
        Line2D line2D = null;
        try {
            line2D = new Line2D(this.getOIJ(), d5, -1.0, d6);
        }
        catch (LineException lineException) {
            System.err.println("Erreur dans Line2D.regLin() !!");
            System.exit(-1);
        }
        return line2D;
    }
}

