/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* This interface defines the stockage of the coeeficients of a Polynom. 
* @author O.C.
* @date 02/2001
* @since Opale-Mathtools 0.12
*/
interface PolynomModel
{
/**
* Returns the coefficient associated with the monome x^i.
* @param int i, the coefficient to get
* @return double, the value of the coefficient
*/
public double get(int i);

/**
* Sets the coefficient i with the value x.
* @param int i, the coefficient to set
* @param double x, the value
*/

public void set(int i, double x);

}

/**
* This class implements the interface <code>PolynomModel> and defines a classic storage for the coefficients. 
* @author O.C.
* @date 02/2001
* @since Opale-Mathtools 0.11
*/
class ClassicPolynomModel implements PolynomModel
{
private double[] a;


/**
* Constructs an object with n coefficients.
* @param int n, the number of coefficients
*
*/
ClassicPolynomModel(int n)
	{
	a = new double[n>=0 ? n : -n];
	}


/**
* Returns the coefficient 'i'.
* @param int i, the coefficient to get
* @return double, the value of the coefficient
*/
public double get(int i)
	{
	return a[i];
	}

/**
* Sets the coefficient i with the value x.
* @param int i, the coefficient to set
* @param double x, the value
*/

public void set(int i, double x)
	{
	a[i] = x;
	}

}
