/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;

import opale.tools.*;
import java.util.*;
import java.io.StreamTokenizer;

/**
* Cette classe permet de contenir un certain nombre d'objets de type <code> Object2D</code> et de repres de type <code>OIJ</code>.
* Elle permet ainsi de tracer tous ces objets avec l'appel unique  la mthode <code>draw(Pen2D c)</code>, de suavegarder ces objets dans un fichier dde donnes et de les relire.
* @author O.C.
* @since Opale-2d 0.1
*/

public class Pack2D
{
private Vector lobjet,lrep;
private static Hashtable objectName,userName; 
private Hashtable id,invId;
private Legend legend;

/** 
* Constructeur par dfaut. Ce constructeur va chercher la ressource "list_object.cfg" afin de rsoudre les noms utilisateurs doones aux classes des objets graphiques.
* Si ce fichier est introuvable, le programme sort en erreur.
*/
public Pack2D()
	{
	lobjet = new Vector(10,10);
	lrep = new Vector(10,10);
	id = new Hashtable();
	invId = new Hashtable();

	objectName = new Hashtable();
	userName = new Hashtable();
	int type;
	String nomClasse="", nomUser="";
	
	try
	{
	java.io.InputStream in = getClass().getResourceAsStream("list_object.cfg");
	RFile rf=null;
	if (in != null)
		rf = new RFile(in);
	else
		{
		System.err.println("Fichier list_object.cfg introuvable.");
		System.err.println("Arret !");
		System.exit(-1);
		}
	type = rf.nextToken();
	while(type != StreamTokenizer.TT_EOF)
		{
		if (type == StreamTokenizer.TT_NUMBER)
			nomClasse = Double.toString(rf.nval);
		else if (type == StreamTokenizer.TT_WORD)
			nomClasse = rf.sval;
		type = rf.nextToken();
		if (type == StreamTokenizer.TT_NUMBER)
			nomUser = Double.toString(rf.nval);
		else if (type == StreamTokenizer.TT_WORD)
			nomUser = rf.sval;
		else if (type == StreamTokenizer.TT_EOF)
			{
			System.err.println("Erreur  la lecture du fichier de configuration");
			System.exit(-1);
			}
		
		objectName.put(nomUser,nomClasse);
		userName.put(nomClasse,nomUser);
		type = rf.nextToken();
		}
	}
	catch(java.io.IOException e)
		{
		System.err.println("Erreur  la lecture du fichier de configuration");
		System.err.println(e);
		System.exit(-1);
		}
	//System.err.println(objectName);
	//System.err.println(userName);
	legend = new Legend(this);

	
	}
	
/**
* Nettoie le pack en le vidant des objets 2d et des repres.
*/	
public void clean()
	{
	lobjet = new Vector(10,10);
	lrep = new Vector(10,10);
	id = new Hashtable();
	invId = new Hashtable();
	}	
	
/**	
* Supprime un objet de type Object2D.
* @param Object2D obj, l'objet  supprimer.
* @return int, -1 si addition impossible, 0 sinon.
*/
public int remove(Object2D obj)
	{
	if ( lobjet.contains(obj) )	
		{
		if (Debug.On) Debug.print("dans Pack2D : " + lobjet);
		lobjet.remove(obj);
		id.remove(getId(obj));
		invId.remove(obj);
		if (Debug.On) Debug.print("dans Pack2D : " + lobjet);
		return 0;
		}
	else
		return -1;
	}

/**
* Ajoute un objet graphique  la liste si l'id est libre et l'objet non dj insr.
* @param Object2D gob, l'objet  ajouter.
* @param String s, l'id de l'objet.
* @return int, -1 si addition impossible, 0 sinon.
*/
public int add(Object2D gob,String s)
	{
	if ( (!contains(s)) && (!contains(gob)) )
		{
		lobjet.add((Object2D) gob);
		id.put(s,(Object2D) gob);
		invId.put((Object2D) gob,s);
		if (Debug.On) Debug.print("Dans Pack2D: " + id);
		return 0;
		}
	else
		return -1;
	}

/**
* Renvoie l'element  la position spcifie dans le vecteur.
* @param int i la position de l'objet  retourner..
* @return Object2D, l'objet retourn
*/
public Object2D getObject(int i)
	{
	return (Object2D) lobjet.get(i);
	}

/**
* Retourne la taille de la liste des objets.
* @return int, le nombre d'objets dans la liste.
*/	
public int sizeObject()
	{
	return lobjet.size();
	}
	
/**
* Copie la liste d'objets dans un tableau.
* @param Object2D[] tab, le tableau qui contiendra les objets.
* @version Opale 0.1
*/
public void ObjectIntoTab(Object2D[] tab)
	{
	lobjet.copyInto(tab);
	}

/**
* Ajoute un repre au pack si celui ci n'a pas t dj ajouter et que son id n'est
pas utilis..
* @param Object2D gob, l'objet  ajouter.
* @param String s, l'id de l'objet.
* @return int, -1 si addition impossible, 0 sinon.
*/
public int add(OIJ rep,String s)
	{
	if ( (!contains(s)) && (!contains(rep)) )
		{
		lrep.add(rep);
		id.put(s,rep);
		invId.put(rep,s);
		if (Debug.On) Debug.print("Dans Pack2D: " + id);
		return 0;
		}
	else
		return -1;
	}

/**
* Renvoie l'element  la position spcifie dans le vecteur.
* @param int i la position de l'objet  retourner..
* @return OIJ, le repere retourn
*/
public OIJ getOIJ(int i)
	{
	return (OIJ) lrep.get(i);
	}
	
/**
* Retourne la taille de la liste.
* @return int, le nombre d'objets dans la liste.
*/	
public int sizeOIJ()
	{
	return lrep.size();
	}
	
/**
* Copie la liste d'objets dans un tableau.
* @param Object2D[] tab, le tableau qui contiendra les objets.
* @version Opale 0.1
*/
public void OIJintoTab(OIJ[] tab)
	{
	lrep.copyInto(tab);
	}

/**
* Renvoie un tableau de String qui contient tous les noms utilisateurs des
objets graphiques.
* @return String[] le tableau de noms.
*/
public String[] getUserNameObject()
	{
	Object[] lobj = objectName.keySet().toArray();
	String[] list = new String[objectName.size()];
	int i;
	
	for (i=0;i<objectName.size();i++)
		list[i] = (String) lobj[i];
	return list;
	}
	
/**
* Renvoie le nom de la classe d'un objet  Object2D  partir de son nom
utilisateur.
* @return String le nom de la classe.
* @param String le nom utilisateur.
*/ 	
public String getNameObject(String username)
	{
	return (String) objectName.get(username);
	}
	
	
/**
* Renvoie le nom utilisateur d'une classe d'un objet Object2D  partir de son
nom Java.
* @param String le nom de la classe.
* @return String le nom utilisateur.
*/ 	
public String getUserName(String objname)
	{
	return (String) userName.get(objname);
	}

/**
* Renvoie l'identificateur d'un objet2D.
* @param Object2D, un objet.
* @return String, l'identificateur correspondant.
*/
public String getId(Object2D obj)
	{
	return (String) invId.get(obj);
	}
	
/**
* Renvoie l'identificateur d'un repre.
* @param OIJ, un repre.
* @return String, l'identificateur correspondant.
*/
public String getId(OIJ oij)
	{
	return (String) invId.get(oij);
	}

/**
* Renvoie un repre  partir de son identificateur.
* @param String, l'identificateur correspondant.
* @return OIJ, le repre, null si l'identificateur ne correspond  aucun repre..
*/
public OIJ OIJfromId(String id)
	{
	if (this.id.get(id) instanceof OIJ)
		return (OIJ) this.id.get(id);
	else return null;
	}
	
/**
* Renvoie un id construit automatiquement du style "obj_n" o n est le
nombre d'lment+1.
* @return String, l'id gnr.
*/
public String getLinearId()
	{
	return "obj"+(sizeOIJ()+sizeObject());
	}

/**
* Teste si la chaine passe en paramtre est un identificateur utilis.
* @param String id, la chaine a tester.
* @return boolean, true si utilis, false sinon.
*/
public boolean contains(String s)
	{
	return id.containsKey(s);
	}

/**
* Teste si l'objet pass en paramtre est dj stock.
* @param Object2D, l'objet  tester.
* @return boolean, true si utilis, false sinon.
*/
public boolean contains(Object2D o)
	{
	return invId.containsKey(o);
	}

/**
* Teste si le repre pass en paramtre est dj stock.
* @param OIJ, l'objet  tester.
* @return boolean, true si utilis, false sinon.
*/
public boolean contains(OIJ o)
	{
	return invId.containsKey(o);
	}


/**
* Lit dans un fichier une liste d'objets et de reperes.
* @param RFile f, le fichier  lire.
*/
public void readFile(RFile f) throws MalformedFileException
	{
	int type;
	
	try
	{
	type = f.nextToken();
	while (type != StreamTokenizer.TT_EOF)
		{
		if (f.sval.equals("OIJ"))
			{
			System.err.println("*Lecture d'un repre de type OIJ.");
			OIJ oij = new OIJ();
			type = f.nextToken();	//on lit l'id
			String id = f.sval;
			oij.readFile(f,this);
			if (add(oij,id)==-1)
				{
				throw new MalformedFileException("Ajout du repre "+oij+" impossible. Identifiant "+id+" dj utilis.");
				}
				
			System.err.println("*Fin de lecture du repre.");
			}
		else
			{
			//System.err.println("lire objet");
			//System.err.println("nom = "+f.sval+" " +getNameObject(f.sval));
			System.err.println("*Lecture d'un objet de type "+f.sval+".");
			if (getNameObject(f.sval) == null) 
				{
				System.err.println("Erreur  la lecture du fichier" + f);
				System.err.println("Impossible d'identifier le type d'objet "+f.sval+".");
				System.exit(-1);
				}	
			Object obj =  Class.forName(getNameObject(f.sval)).newInstance();
			Object2D ob = (Object2D) obj;
			f.nextToken();	//on lit l'id
			String id = f.sval;
			if (Debug.On) Debug.print(id);
			ob.readFile(f,this);
			if (add(ob,id) == -1)
				{
				//System.err.println("Ajout de l'objet "+ob+" impossible. Identifiant "+id+" dj utilis.");
				//System.exit(-1);
				throw new MalformedFileException("Ajout de l'objet "+ob+" impossible. Identifiant "+id+" dj utilis.");
				}
			System.err.println("*Fin de lecture d'un objet.");

			}
			 
		type = f.nextToken();
		}
	}
	catch (java.io.IOException e)
	{
	System.err.println("Erreur  la lecture du fichier" + f);
	System.err.println(e);
	System.exit(-1);
	}	
	catch(ClassNotFoundException exc)
	{
	throw new MalformedFileException("Erreur  la lecture d'un objet de type "+f.sval+" : la classe n'existe pas.");
	}
	catch(IllegalAccessException exc)
	{
	throw new MalformedFileException("Erreur  la lecture d'un objet de type "+f.sval+" : acces  la classe impossible.");
	}
	catch(InstantiationException exc)
	{
	throw new MalformedFileException("Erreur  la lecture d'un objet de type "+f.sval+" : classe non instanciable.");
	}
	}
	

/**
* Ecris dans un fichier le contenu de ce Pack2D.
* @param WFile f, le fichier dans lequel on veux ecrire.
*/
public void writeFile(WFile f) throws MalformedFileException
	{
	int i;
	for (i=0; i<sizeOIJ();i++)
		{
		if (Debug.On) Debug.print(getId(getOIJ(i)));
		f.writeString("OIJ");
		f.writeln(getId(getOIJ(i)));
		getOIJ(i).writeFile(f,this);
		}
		
	for (i=0; i<sizeObject();i++)
		{
		Object2D obj = getObject(i);
		f.writeString(getUserName(obj.getClass().getName()));
		f.writeln(getId(obj));
		obj.writeFile(f,this);
		}
	}

/**
* Retourne l'instance de la lgende associ  ce pack.
* @return Legend, la lgende.
* @since Opale-2d 0.11
*/
public Legend legend()
	{
	return legend;
	}
	

/**
* Dessine tous les objets contenus dans le pack.
* @param Pen2D c, l'instance de Pen2D pour dessiner.
*/
public void draw(Pen2D c)
	{
	int i;
	legend.draw(c);
	for (i=0; i<sizeObject();i++)
		{
		if ( getObject(i) instanceof GObject2D )
			{
			GObject2D obj = (GObject2D)  getObject(i);
			c.draw(obj);
			}
		}
	}
}
