/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.m2d.ker;
import opale.tools.*;
import java.io.StreamTokenizer;

/**
* This abstract class is the root of the class hierarchy that represents an object 2D.
* @author OC
* @since Opale-2d 0.1
*/
public abstract class Object2D implements Cloneable
{
private OIJ rep;	//Tout objet 2d est dfini dans un repre OIJ.
/**
* Constructs and initializes with the absolute OIJ.
*/
public Object2D()
	{
	this.rep = OIJ.OIJ_ABSOLUTE;
	}
	
/**
* Constructs and initializes with an specified OIJ.
* @param OIJ rep, an instance of <code>OIJ</code>.
*/
public Object2D(OIJ rep)
	{
	this.rep = rep;
	}

/**
* Sets the OIJ basis of this object.
* @param OIJ rep,  the new OIJ.
*/
public void setOIJ(OIJ rep)
	{
	this.rep = rep;
	}
	
	
/**
* Returns the instance <code>OIJ</code> of this object.
* @return OIJ rep, the basis of this object.
*/
public OIJ getOIJ()
	{
	return rep;
	}
	
/**
* Creates a new object of the same class and with the same contents as this vector.
* @return Object, a clone of this instance.
* @exception  OutOfMemoryError if there is not enough memory.
* @see        java.lang.Cloneable
*/
public Object clone()
	{
	try
		{
		Object2D obj = (Object2D) super.clone();
		obj.rep = rep;
		return obj;
		}
	catch (CloneNotSupportedException e) // ne devrait jamais arriver
		{
		throw new InternalError();
		}
    }

/**
* Reads in a file the construction of this object calling the method <code>readKeyWord().</code>
* @param RFile f, the file to read.
* @prama Pack2D p, instance of <code>Pack2D</code> that contains the requiered objects (OIJ, others objects 2d...).
*/
public void readFile(RFile f,Pack2D pack) throws java.io.IOException,MalformedFileException
	{
	int type;
	OIJ lerepere=null;

	type = f.nextToken();	//on lit la premiere '{'
	if ( (type !=StreamTokenizer.TT_WORD) || !f.sval.equals("{") ) throw new MalformedFileException("Data file "+f+" is wrong !!");
	type = f.nextToken();	
	do
		{
		if (type != StreamTokenizer.TT_WORD)  throw new MalformedFileException("Data file "+f+" is wrong : we want a keyword !!");
		if ((f.sval).equals("OIJ"))
			{
			type =f.nextToken();
			if (type != StreamTokenizer.TT_WORD) throw new MalformedFileException("Data file "+f+" is wrong  : error reading an OIJ");
			if (Debug.On) Debug.print("Dans Object2D : "+pack.contains(f.sval));
			if (Debug.On) Debug.print("Dans Object2D : "+pack.OIJfromId(f.sval));
			if ( (!pack.contains(f.sval)) || (pack.OIJfromId(f.sval)) == null) throw new MalformedFileException("Data file "+f+" is wrong  : the identifiant "+f.sval+" doesn't exist !!");
			lerepere = pack.OIJfromId(f.sval);
			} 
			
		else if (readKeyWord(f.sval,f,pack) == -1) throw new MalformedFileException("Data file "+f+" is wrong   : error reading a keyword !!");
		type = f.nextToken();
		}
	while ((type !=StreamTokenizer.TT_WORD) || !f.sval.equals("}") );

	if (lerepere == null) throw new MalformedFileException("No OIJ for this object !!"+this);
	setOIJ(lerepere);
	
	
	}

	
/**
* Computes the changement of OIJ for this object.
* @param OIJ rep, the new OIJ.
*/	
public abstract void changeOIJ(OIJ rep);


/**
* Returns a string representation of this object.
*/
public abstract String toString();


/**
* Interpret a keyword read in a file.
* @param String word, the keyword.
* @param RFile f, the file in reading.
* @param Pack2D p, instance of <code>Pack2D</code> that contains the requiered objects.
* @return int, 0 if the keyword is good, -1 otherwise.
*/
public abstract int readKeyWord(String word, RFile f,Pack2D pack) throws java.io.IOException, MalformedFileException; 

/**
* Writes informations about this object in a file.
* @param WFile f, the file in writing.
*/
public void writeFile(WFile f,Pack2D pack) throws MalformedFileException
	{
	f.writeln("{");
	if (!pack.contains(getOIJ())) throw new MalformedFileException("Error writing the file "+f+" : the OIJ "+getOIJ()+" doesn't exist !!");
	f.writeln("OIJ "+pack.getId(getOIJ()));
	writeFileMore(f,pack);
	f.writeln("}");
	}
		
/**
* Wrtie complementary information in a file.
* @param WFile f, the file in writing .
*/
public abstract void writeFileMore(WFile f,Pack2D pack);

/**
* Returns the maximum of the X coordinate.
* @return double, X maximum.
*/
// A FAIRE !!!! //
public double xmax() {return 0;};


}
