/*
 * Decompiled with CFR 0.152.
 */
package opale.mathtools;

import opale.mathtools.DVect;
import opale.mathtools.IFnn;

public final class FixPoint {
    public static double PRECISION = 1.0E-6;
    public static int MAXITERATION = 100;

    public static void solve(IFnn iFnn, int n, DVect dVect, DVect dVect2) {
        int n2 = 0;
        boolean bl = false;
        double[] dArray = new double[n];
        DVect dVect3 = new DVect(dVect);
        while (n2 < MAXITERATION && !bl) {
            dVect3.get(dArray);
            dVect2.set(iFnn.val(dArray));
            dVect3.sub(dVect2);
            double d = dVect3.norm2Sq() / dVect2.norm2Sq();
            dVect3.set(dVect2);
            if (d < PRECISION) {
                bl = true;
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        DVect dVect = new DVect(2);
        DVect dVect2 = new DVect(2);
        FixPoint.solve(new IFnn(){

            public double[] val(double[] dArray) {
                double[] dArray2 = new double[]{1.0 + 0.1 * dArray[0] * dArray[1] - dArray[1], 0.5 * dArray[0] + 0.5 * dArray[0] * dArray[1]};
                return dArray2;
            }
        }, 2, dVect, dVect2);
        System.err.println(dVect2);
    }
}

