/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.object2d;

import java.io.IOException;
import opale.m2d.ker.OIJ;
import opale.m2d.ker.Object2D;
import opale.m2d.ker.Pack2D;
import opale.tools.MalformedFileException;
import opale.tools.RFile;
import opale.tools.WFile;

public class Conic
extends Object2D
implements Cloneable {
    protected double e;
    protected double p;
    protected double theta0;
    protected int N;

    public Conic() {
        this.N = 100;
        this.e = 1.0;
        this.p = 1.0;
        this.theta0 = 0.0;
    }

    public Conic(OIJ oIJ) {
        super(oIJ);
        this.N = 100;
        this.e = 1.0;
        this.p = 1.0;
        this.theta0 = 0.0;
    }

    public Conic(Conic conic) {
        super(conic.getOIJ());
        this.N = conic.N;
        this.e = conic.e;
        this.p = conic.p;
        this.theta0 = conic.theta0;
    }

    public void set(int n) {
        this.N = Math.max(2, n);
    }

    public void setParams(double d, double d2, double d3) {
        if (d > 0.0) {
            this.e = d;
        }
        this.p = d2;
        this.theta0 = d3 % (Math.PI * 2);
    }

    public Object clone() {
        Conic conic = (Conic)super.clone();
        return conic;
    }

    public void changeOIJ(OIJ oIJ) {
    }

    public void writeFileMore(WFile wFile, Pack2D pack2D) {
        wFile.writeln("N " + this.N);
        wFile.writeln("e " + this.e);
        wFile.writeln("p " + this.p);
        wFile.writeln("theta0 " + this.theta0);
    }

    public int readKeyWord(String string, RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        if (string.equals("N")) {
            int n = rFile.nextToken();
            this.N = (int)rFile.nval;
            return 0;
        }
        if (string.equals("e")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            if (!(this.e > 0.0)) {
                throw new MalformedFileException("L'e'xcentricit\u00e9 doit \u00eatre strictement positive. Impossible de construire la conique " + this);
            }
            this.e = rFile.nval;
            return 0;
        }
        if (string.equals("p")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.p = rFile.nval;
            return 0;
        }
        if (string.equals("theta0")) {
            int n = rFile.nextToken();
            if (n != -2) {
                return -1;
            }
            this.theta0 = rFile.nval % (Math.PI * 2);
            return 0;
        }
        return -1;
    }

    public String toString() {
        String string = "r(t) = " + this.p + "/(1 + " + this.e + "cos(t - " + this.theta0 + ")";
        return string;
    }

    public static void main(String[] stringArray) {
        System.out.println(-1.0);
    }
}

