/*
 * Decompiled with CFR 0.152.
 */
package opale.m2d.ker;

import opale.m2d.ker.OIJ;

public abstract class CoordSystem {
    protected double xmin = -10.0;
    protected double ymin = -10.0;
    protected double xmax = 10.0;
    protected double ymax = 10.0;
    protected int width;
    protected int height;
    protected int borderX;
    protected int borderY;
    protected OIJ oij;

    public void setOIJ(OIJ oIJ) {
        this.oij = oIJ;
    }

    public OIJ getOIJ() {
        return this.oij;
    }

    public abstract void autoadjust();

    public abstract void normadjust();

    public abstract int X(double var1, double var3);

    public abstract int Y(double var1, double var3);

    public abstract double xfromXY(int var1, int var2);

    public abstract double yfromXY(int var1, int var2);

    public abstract double normSq(double var1, double var3);

    public final int setXmin(double d) {
        if (d < this.xmax) {
            this.xmin = d;
            return 0;
        }
        return -1;
    }

    public final int setYmin(double d) {
        if (d < this.ymax) {
            this.ymin = d;
            return 0;
        }
        return -1;
    }

    public final int setXmax(double d) {
        if (this.xmin < d) {
            this.xmax = d;
            return 0;
        }
        return -1;
    }

    public final int setYmax(double d) {
        if (this.ymin < d) {
            this.ymax = d;
            return 0;
        }
        return -1;
    }

    public final int set(double d, double d2, double d3, double d4) {
        if (d3 < d4 && d < d2) {
            this.xmax = d2;
            this.ymax = d4;
            this.ymin = d3;
            this.xmin = d;
            return 0;
        }
        return -1;
    }

    public final double getXmin() {
        return this.xmin;
    }

    public final double getYmin() {
        return this.ymin;
    }

    public final double getXmax() {
        return this.xmax;
    }

    public final double getYmax() {
        return this.ymax;
    }

    public final void setSize(int n, int n2, int n3, int n4) {
        if (n3 > 0 && n4 > 0 && n >= 0 && n2 >= 0) {
            this.width = n3;
            this.height = n4;
            this.borderX = n;
            this.borderY = n2;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getXinf() {
        return this.borderX;
    }

    public int getYinf() {
        return this.borderY;
    }

    public boolean test(double d, double d2) {
        return d >= this.xmin && d <= this.xmax && d2 >= this.ymin && d2 <= this.ymax;
    }
}

