/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.tools;
import java.io.*;
/**
* Cette classe encapsule des methodes pour ecrire les types de base de Java dans un fichier sous forme ASCII.
* @version 0.1
* @author O.C.
*/

public class WFile
{
private String name;
private PrintWriter out;
private FileWriter fw;

/**
* constructeur qui prend en argument le nom du fichier  ouvrir en ecriture.
* @param String name, le nom du fichier.
* @since Opale 0.1
*/
public WFile(String name) throws IOException
	{
	this.name = name;
	out = new PrintWriter(fw = new FileWriter(name));
	}	

/**
* constructeur qui prend en argument le nom du fichier  ouvrir en ecriture, et
le mode de vidage(automatique ou non).
* @param String name, le nom du fichier.
* @param boolean auto, true=autoFlush.
* @since Opale 0.1
*/
public WFile(String name, boolean auto) throws IOException
	{
	this.name = name;
	out = new PrintWriter(fw = new FileWriter(name),auto);
	}	

public void writeInt(int n)
	{
	out.print(n);
	out.print(" ");
	}

public void writeDouble(double x)
	{
	out.print(x);
	out.print(" ");
	}

public void writeFloat(float x)
	{
	out.print(x);
	out.print(" ");
	}

public void writeChar(char c)
	{
	out.print(c);
	out.print(" ");
	}

public void write(String s)
	{
	out.print(s);
	out.print(" ");
	}

public void writelnInt(int n)
	{
	out.println(n);
	}

public void writelnDouble(double x)
	{
	out.println(x);
	}

public void writelnFloat(float x)
	{
	out.println(x);
	}

public void writelnChar(char c)
	{
	out.println(c);
	}

public void writeln(String s)
	{
	out.println(s);
	}

protected void finalize() 
	{
	out.close();
	}

public void close()
	{
	out.close();
	}

public String toString()
	{
	return name;
	}
	

}
