/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/
package opale.ode;

import opale.mathtools.*;

/**
* Permet de construire dynamiquement une quation en dfinissant les valeurs de son second membre grace  des chaines de caractres. Ces chaines seront interprtes par un parser. Avec cette classe, il faut se limiter  des problmes de dimension comprise entre 1 et 3 c'est  dire que la fonction vectorielle f est dfinie sur I x R ou I x R ou I x R ; de plus les variables dans cette fonction seront nommes par t, x, y, z dans leur ordre d'apparition.
* @version 0.1
* @author O.C.
*/

public class SEquation
{
private int dim;
private String[] fonc;
private ParseFunction[] parser;
private double[] resu;

/**
* Prend en argument un tableau de chaines de carcatres correspondant aux composantes de la fonction second memebre de l'quation. Ce tableau ne doit pas comporter plus de 3 lments sinon il est rejet et la fonction non interprt. Si ce tableau compirte 1 lment alors la chaine de caractres ne doit comporter que les variables t et x ; si il en comporte 2 alors les deux chaines doivent comporter les variables t, x, et y ; si enfin il en comporte 3 alors on peut trouver t, x, y , z comme variables dans la chaine. Dans tous les cas si un problme se produit (mauvaise dimension ou mauvaises variables) la mthode renvoie false.
* @param String[], le tableau de chaine de caractres dfinissant les composantes de la fonction second membre.
* @return boolean, true si la fonction a pu etre pars sans problme, false sinon.
* @since Opale 0.1
*/

public boolean setFonc(String[] f)
	{
	if ((f.length<1) || (f.length>3))
		return false;
	dim = f.length;
	parser = new ParseFunction[dim];
	resu = new double[dim];
	fonc = new String[dim];
	int i;
	for (i=0;i<dim;i++)
		{
		parser[i] = new ParseFunction();
		if (parser[i].parse(f[i]))
		{
		boolean[] b = parser[i].getVariables();
		if ( ((dim==1) &&( b[1] || b[2])) || ((dim==2) &&(b[2])) )
			return false;
		}
		fonc[i] = f[i];
		}
	return true;
	
	}

/**
* Renvoie la dimension de l'espace d'appartenance de l'inconnu de l'quation.
* @return int, la dimension.
* @since Opale 0.11
*/
public int dim()
	{
	return dim;
	}

/**
* Dfinit la fonction f du second membre de l'quation.
* @param double t, le paramtre temps (paramtre de drivation).
* @param double[] x, les paramtres inconnus.
* @return double[], la valeur de f pour le point (t,x).
* @since Opale 0.11
*/
public double[] deriv(double t, double[] x)
	{
	try
	{
	int i;
	if (dim == 1)
		resu[0] = parser[0].getResult(t,x[0],0,0);
	else if (dim == 2)
		{
		resu[0] = parser[0].getResult(t,x[0],x[1],0);
		resu[1] = parser[1].getResult(t,x[0],x[1],0);
		}
	else if (dim == 3)
		{
		resu[0] = parser[0].getResult(t,x[0],x[1],x[2]);
		resu[1] = parser[1].getResult(t,x[0],x[1],x[2]);
		resu[2] = parser[2].getResult(t,x[0],x[1],x[2]);
		}
	}
	catch(Exception e)
		{
		System.err.println(e);
		System.err.println("Ne devrait jamais arriver");
		System.exit(-1);
		}
	
	return resu;
	}

public String toString()
	{
	String s="";
	if (dim ==1)
		s = "f(t,x) = "+fonc[0];
	else if (dim == 2)
		{
		s = "f1(t,x,y) = "+fonc[0]+"\n";
		s += "f2(t,x,y) = "+fonc[1];
		}
	else if (dim == 3)
		{
		s = "f1(t,x,y,z) = "+fonc[0]+"\n";
		s += "f2(t,x,y,z) = "+fonc[1]+"\n";
		s += "f3(t,x,y,z) = "+fonc[2];
		}
	return s;
	}	

	
public static void main(String[] arg)
	{
	double[] x = new double[3];
	x[0] = 3;
	x[1] = 1;
	x[2] = -5;
	
	SEquation seq = new SEquation();
	String[] fonc = new String[3];
	fonc[0] = "x*z-y-3*t";
	fonc[1] = "2*x+y*z+t";
	fonc[2] = "-2*x+y-z*t";
	System.err.println(seq.setFonc(fonc));
	System.err.println( seq.deriv(-34,x)[2]);
	System.err.println( seq);
	
	
	}	
	
}
