/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/
package opale.ode;


/**
* Cette interface est  implmenter pour dfinir une quation pour un problme d'ODE du type (xi)'=f(t,x1,...,xn) pour i=1  n. Deux mthodes sont  implmenter : la mthode dim() qui renvoie la dimension de l'quation (c'est--dire le nombre d'inconnues qui doit tre gal au nombre de composantes renvoyes  savoir le nombre n) ; et la mthode double[] deriv(double t, double[] x) qui dfinit le second membre f(t,x1,...,xn) de l'quation.
* @version 0.1
* @author O.C.
*/

public interface Equation
{
/**
* Renvoie la dimension de l'espace d'appartenance de l'inconnu de l'quation.
* @return int, la dimension.
* @since Opale 0.11
*/
public int dim();

/**
* Dfinit la fonction f du second membre de l'quation.
* @param double t, le paramtre temps (paramtre de drivation).
* @param double[] x, les paramtres inconnus.
* @return double[], la valeur de f pour le point (t,x).
* @since Opale 0.11
*/
public double[] deriv(double t, double[] x);
}
