/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.object2d;
import opale.module2d.noyau2d.*;
import opale.tools.*;

/**
* Cette classe reprsente une droite graphique; elle tend la classe <code>Line2D</code>.
* @author O.C.
* @version 0.1
*/

public class GLine2D extends Line2D implements GObject2D, Cloneable
{

private InfoLine info;

/**
* Constructeur par dfaut.
* @since Opale 0.1
*/
public GLine2D()
	{
	super();
	System.out.println("Dans GLine2D()");
	info = new InfoLine();
	}
	
/**
* Constructeur d'une instance de GLine2D  associ  un  rpre OIJ et d'quation donne.
* @param OIJ rep, le repre de dfinition de la droite.
* @param double a,b,c, les coefficients de l'quation ax+by+c=0.
* @since Opale 0.1
*/
public GLine2D(OIJ rep,double a, double b, double c) throws LineException
	{
	super(rep,a,b,c);
	info = new InfoLine();
	}
	
/**
* Constructeur d'une instance de GLine2D   partire d'une instance de Line2D.
* @param Line2D l, l'instance de Line2D
* @since Opale 0.11
*/
public GLine2D(Line2D l)
	{
	super(l);
	info = new InfoLine();
	}
	
/**
* Constructeur d'une instance de GLine2D  associ  un  rpre OIJ et passant par deux points donns.
* @param OIJ rep, le repre de dfinition de la droite.
* @param double x1,y1,x2,y2, les coordonnes des deux points.
* @since Opale 0.1
*/
public GLine2D(OIJ rep,double x1, double y1, double x2, double y2) throws LineException
	{
	super(rep,x1,y1,x2,y2);
	info = new InfoLine();
	}

/**
* Constructeur d'une instance de Line2D passant par deux points donns. Le repre de la droite est celui du premier point.
* @param Point2D p, Point2D q, les deux points.
* @since Opale 0.1
*/
public GLine2D(Point2D p, Point2D q) throws LineException
	{
	super(p,q);
	info = new InfoLine();
	}
	

/**
* Constructeur d'une instance de GLine2D passant par un point et de vecteur directeur donn. Le repre de la droite est du premier point.
* @param Point2D p, le point.
* @param Vector2D v, le vecteur directeur.
* @since Opale 0.1
*/
public GLine2D(Point2D p, Vector2D v)
	{
	super(p,v);
	info = new InfoLine();
	}


//mthodes  implementer de GObject2D
public void draw(Pen2D p)
	{
	double x0,y0,x1,y1;

	if ( info.isVisible())
		{
		p.setColor(info.getColor());
		if ( Math.abs(a)>EPSILON )
			{
			y0 = p.getCoordSyst().getYmin();
			x0 = (-c - b*y0)/a;
			y1 = p.getCoordSyst().getYmax();
			x1 = (-c - b*y1)/a;
			p.drawLine(x0,y0,x1,y1);
			}
		else if ( Math.abs(b)>EPSILON )
			{
			x0 = p.getCoordSyst().getXmin();
			y0 = -c/b;
			x1 = p.getCoordSyst().getXmax();
			y1 = -c/b;
			p.drawLine(x0,y0,x1,y1);
			}
		else
			{
			}
		}
	}
	
public InfoObject getInfo()
	{
	return info;
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	try
		{
		GLine2D p = (GLine2D) super.clone();
		p.info = (InfoLine) info.clone();
		return p;
		}
	catch (InternalError e) // ne devrait jamais arriver
		{
		throw e;
		}
    }

public int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	if ( word.equals("INFO"))
		{
		info.readFile(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeFileMore(WFile f, Pack2D p)
	{
	info.writeFile(f,p);
	super.writeFileMore(f,p);
	}	

}
