/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.object2d;
import opale.module2d.noyau2d.*;
import opale.tools.*;

/**
* Cette classe reprsente un nuage de points graphique; elle tend la class <code>Data2D</code>.
* @author O.C.
* @version 0.1
*/


public class GData2D extends Data2D implements GObject2D,  Cloneable
{
private InfoData info; 
private String legende;

/**
* Constructeur par dfaut.
* @since Opale 0.1
*/
public GData2D()
	{
	super();
	System.out.println("Dans GData2D()");
	info = new InfoData();
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
* @since Opale 0.1
*/
public GData2D(OIJ rep)
	{
	super(rep);
	info = new InfoData();
	}
/**
* Construit et initialise le nuage  partir d'un Data2D et avec les informations par dfaut.  
* @param Data2D d, le nuage.
* @since Opale 0.1
*/
public GData2D(Data2D d)
	{
	super(d);
	info = new InfoData();
	}


/**
* Le constructeur de copie
* @param GData d, l'objet  copier.
* @since Opale 0.1
*/
public GData2D(GData2D d)
	{
	super(d);
	info = new InfoData((InfoData) d.getInfo());
	}

public int readKeyWord(String word, RFile f, Pack2D p) throws java.io.IOException, MalformedFileException
	{
	if ( word.equals("INFO"))
		{
		info.readFile(f,p);
		return 0;
		}
	else return super.readKeyWord(word,f,p);
	}

public void writeFileMore(WFile f, Pack2D p)
	{
	info.writeFile(f,p);
	super.writeFileMore(f,p);
	}	


public void draw(Pen2D c)
	{
	int i;

	if ( info.isVisible())
		{
		c.setColor(info.getColor());
		if ( info.getTypeGraph() == 0)
			for (i=0;i<nbPts-1;i++)
				c.drawLine(x[i],y[i],x[i+1],y[i+1]);
		else if  ( info.getTypeGraph() == 1)
			{}
		else  if  (info.getTypeGraph() == 2)		
			for (i=0;i<nbPts;i++)
				c.drawLine(x[i],0,x[i],y[i]);
		else  if  (info.getTypeGraph() == 3)		
			for (i=0;i<nbPts;i++)
				c.drawLine(0,y[i],x[i],y[i]);
		else if  ( info.getTypeGraph() == 4) 
			for (i=0;i<nbPts;i++)
				{
				c.drawLine(x[i],0,x[i],y[i]);
				c.drawLine(0,y[i],x[i],y[i]);
				}
		int symb = info.getStylePoint();
		int taille = info.getSizePoint();
		if (symb == 1)
			for (i=0;i<nbPts;i++)
				c.drawPoint(x[i],y[i]);
		else if (symb == 2)			
			for (i=0;i<nbPts;i++)
				c.drawPlus(x[i],y[i],taille);
		else if ( symb == 3)	//on dessine un X      
			for (i=0;i<nbPts;i++)
				c.drawX(x[i],y[i],taille);
		else if ( symb == 4)	//on dessine un cercle      
			for (i=0;i<nbPts;i++)
				c.drawCircle(x[i],y[i],taille);
		else if ( symb == 5)	//on dessine un carr       
			for (i=0;i<nbPts;i++)
				c.drawSquare(x[i],y[i],taille);
		else if ( symb == 6)	//on dessine un diamant       
			for (i=0;i<nbPts;i++)
				c.drawDiamond(x[i],y[i],taille);
		else if ( symb == 7)	//on dessine un triangle haut
			for (i=0;i<nbPts;i++)
				c.drawTriangleUp(x[i],y[i],taille);
		else if ( symb == 8)	//on dessine un triangle bas
			for (i=0;i<nbPts;i++)
				c.drawTriangleDown(x[i],y[i],taille);
		else if ( symb == 9)	//on dessine un triangle gauche
			for (i=0;i<nbPts;i++)
				c.drawTriangleLeft(x[i],y[i],taille);
		else if ( symb == 10)	//on dessine un triangle droit
			for (i=0;i<nbPts;i++)
				c.drawTriangleRight(x[i],y[i],taille);
		}
	}
	
	
public InfoObject getInfo()
	{
	return info;
	}
	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	GData2D gd = (GData2D) super.clone();
	gd.info = (InfoData) info.clone();
	return gd;
	}

public void drawLegend(Pen2D c,int x, int y,int w, int h)
	{
	if ( info.isVisible())
		{
		c.setColor(info.getColor());
		if ( info.getTypeGraph() !=1)
			c.drawLine(x,y+h/2,x+w,y+h/2);
		else 
			{}
		}
	}
	
public String getLegend()
	{
	return info.getName();
	}
public void setLegend(String t)
	{
	info.setName(t);
	}

}
