package opale.module2d.component2d;
import opale.module2d.noyau2d.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

public class JFrame2D extends JFrame  
{
private Pack2D pack;
private	CoordSystem vue;
private	GAxis2D axes;

/**
* constructeur par dfaut d'un objet de type Frame2D. La fermeture de la fenetre est gre; par dfaut elle possde une taille de 300x300.
* @since Opale 0.11
*/
public JFrame2D()
	{
	setTitle("Opale v0.11 - JFrame 2d");
	setSize(300,300);

	addWindowListener(new WindowAdapter()
		{
		public void windowClosing(WindowEvent evt)
			{
			System.exit(0);
			}
		}
		);
		
	vue = new LinLinCS(new OIJ(),0,0,300,300);
	axes = new GAxis2D(vue); axes.drawLabel(false);
	((InfoAxis) axes.getInfo()).setTick(0,1,0,1);
	
	pack = new Pack2D();
	getContentPane().add(new DrawPanel(),"Center");	
		
	}
	
/**
* Renvoie la rfrence  l'instance de Pack2D contenu dans l'objet courant Frame2D.
* @return Pack2D, l'instance de Pack2D.
* @since Opale 0.11
*/
public Pack2D getPack2D()
	{
	return pack;
	}

/**
* Renvoie la rfrence  l'instance de GAxis2D contenu dans l'objet courant JFrame2D.
* @return GAxis2D, l'instance de GAxis2D.
* @since Opale 0.11
*/
public GAxis2D getAxis()
	{
	return axes;
	}
	
/**
* Renvoie la rfrence au systme de coordonnes contenu dans l'objet courant JFrame2D.
* @return CoordSystem, l'instance de CoordSystem.
* @since Opale 0.11
*/
public CoordSystem getCS()
	{
	return vue;
	}

class DrawPanel extends JPanel
{

DrawPanel()
	{
	vue.setSize(20,20,getWidth()-40,getHeight()-40);
	addComponentListener(new ComponentAdapter()
		{
		public void componentResized(ComponentEvent e)
			{
			vue.setSize(20,20,getWidth()-40,getHeight()-40);
			vue.autoadjust();
			repaint();
			}
		});

	}

public void paintComponent(Graphics g)
	{
	super.paintComponent(g);
	g.drawRect(5,5,getWidth()-10,getHeight()-10);
	Pen2D c = new Pen2D(g,vue);
	axes.draw(c);
	c.clip();
	pack.draw(c);
	}
	
}


public static void main(String[] arg)
	{
	JFrame2D f =new JFrame2D();
	f.show();
	}
	
}






