/*
Copyright (C) 2000  Olivier Cioni

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.module2d.object2d;
import opale.module2d.noyau2d.*;
import opale.tools.*;
import opale.mathtools.*;

/**
* Cette classe tend <code>Gdata2D</code> et reprsente graphiquemnet une fonction y =f(x).
* @version 0.1
* @author O.C.
*/

public class GyFx extends GData2D implements Cloneable
{

private double xinf, xsup;

/**
* Constructeur par dfaut.
* @since Opale 0.1
*/
public GyFx()
	{
	super();
	System.out.println("Dans GyFx()");
	xinf = xsup = 0;
	}

/**
* Construit et initialise le nuage avec 0 points et avec les informations par dfaut.  
* @param OIJ rep, le repre.
* @since Opale 0.1
*/
public GyFx(OIJ rep)
	{
	super(rep);
	xinf = xsup = 0;
	}


/**
* Le constructeur de copie
* @param GData d, l'objet  copier.
* @since Opale 0.1
*/
public GyFx(GyFx f)
	{
	super(f);
	this.xinf = f.xinf;
	this.xsup = f.xsup;
	nbPts = f.nbPts;
	
	}

/**
* Fixe la fonction a tracer, les bornes de dfinition et le nombre de points.
* @param IyFx f, la fonction  dessiner.
* @param double xinf, xsup, les bornes du domaine de dfinition.
* @param int n, le nombre de points  considerer sur la courbe.
* @since Opale 0.1
*/
public void set(IyFx f, double inf, double sup, int n)
	{
	nbPts = Math.max(2,n); 
	
	if ( inf < sup )
		{
		this.xinf = inf;
		this.xsup = sup;
		}
	else
		{
		this.xinf = sup;
		this.xsup = inf;
		}
		
	x = new double[nbPts];
	y = new double[nbPts];
	int i;
	double pas = Math.abs(xsup-xinf)/(nbPts-1);
	
	for (i=0;i<nbPts;i++)
		{
		x[i] = xinf + i*pas;
		y[i] = f.val(x[i]);
		}
	}
	

	
/**
* Cre un nouvel objet de mme classe et de mme contenu.
* @return Object un clone de l'objet.
* @exception  OutOfMemoryError s'il n'y a pas assez de mmoire.
* @see        java.lang.Cloneable
* @since Opale 0.1
*/
public Object clone()
	{
	GyFx gy = (GyFx) super.clone();
	return gy;
	}

}
