/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;

/**
* Cette classe abstraite est  etendre pour dfinir des mthodes de tri. La mthode  implmenter est la mthode <code>sort</code>..
* @author O.C.
* @version 0.1
*/
public abstract class Sort
{

/**
* Renvoie le maximum d'un tableau de <code>double</code>
* @param int, la taille du tableau.
* @param double[], le tableau de double.
* @return double, le maximum du tableau.
* @since Opale 0.1
*/
final static double getMax(int n, double[] tab)
	{
	double max;
	
	max = tab[n-1];
	for (;n>=0;n--)
		if (tab[n] > max) max = tab[n];
	return max;
	}

/**
* Renvoie le minimum d'un tableau de <code>double</code>
* @param int, la taille du tableau.
* @param double[], le tableau de double.
* @return double, le minimum du tableau.
* @since Opale 0.1
*/
final static double getMin(int n, double tab[])
	{
	double min;
	
	min=tab[n-1];
	for (;n>=0;n--)
		if (tab[n] < min) min = tab[n];
	return min;
	}
/**
* Mthode abstraite  implementer pour dfinir des mthodes de tri d'un tableau.
* @param int, la taille du tableau  trier.
* @param double[], le tableau  trier.
* @since Opale 0.1
*/
abstract void sort(int n, double[] tab);

}

