/*
Copyright (C) 2000  Groupe Opale (http://www.opale.ovh.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

You can visit the web site http://www.opale.ovh.org to obtain more informations about this program and/or to contact the coders.
*/


package opale.mathtools;
	
/**
* Cette classe modlise un vecteur de double et fournit des mthodes de calculs sur ce vecteur.
* @version 0.1
* @author O.C.
*/
public class DVect
{
private double[] x;
private int n;

/**
* Constructeur par dfaut qui prend en argument le nombre de composantes et les valeurs.
* @param int n, le nombre de composantes.
* @param double[] v, le tableau des valeurs.
* @since Opale 0.1
*/
public DVect(int n, double[] v)
	{
	x = new double[n];
	this.n = n;
	for(n=0;n<this.n;n++)
		x[n] = v[n];
	}
	
/**
* Constructeur de copie.
* @param DVect v, le vecteur a copier.
* @since Opale 0.1
*/
public DVect(DVect v)
	{
	int i;
	
	this.n = v.n;
	x = new double[n];
	for(i=0;i<this.n;i++)
		x[i] = v.x[i];
	}
	
		
/**
* Fixe les valeurs du vecteur  partir d'un autre.
* @param DVect v, le vecteur  copier.
* @since Opale 0.1
*/
public void set(DVect v)
	{
	//if ( n != v.n) 
	//	throws ...;

	int i;
	for(i=0;i<this.n;i++)
		x[i] = v.x[i];
	}

/**
* Fixe la valuer d'une composante.
* @param int i, l'indice de la composante  modifier.
* @param double x, la nouvelle valeur.
* @since Opale 0.1
*/	
public void set(int i, double x)
	{
	//if (i < n)
		this.x[i] = x;
	//else throws...;
	}	
	
/**
* Fixe toutes les valeurs du vecteur.
* @param double[] x, le tableau des nouvelles valeurs.
* @since Opale 0.1
*/
public void set(double[] x)
	{
	//if (x.size() != n)
		//throws ...;

	int i;
	for(i=0;i<this.n;i++)
		this.x[i] = x[i];
	}
	


/**
* Renvoie la valeur d'une composante.
* @param int i, le numero de la composante.
* @return double, la valeur de la composante.
* @since Opale 0.1
*/
public double get(int i)
	{
	//if ( (i < n) && (i=>0) )
		return x[i];
	//else throws...;
	}	

/**
* Renvoie toutes les valeurs du vecteur sous forme de tableau.
* @param double[] x, le tableau qui contiendra les valeurs des composantes.
* @since Opale 0.1
*/	
public void get(double[] a)
	{
	//if ( a.size() != n)
	//	throws ...:
	int i;
	for(i=0;i<n;i++)
		a[i]=x[i];
	}

/**
* Renvoie la taille du vecteur.
* @return int n, la taille.
* @since Opale 0.1
*/
public double getSize()
	{
	return n;
	}

/**
* Additionne un vecteur.
* @param DVect v, le vecteur  additionner.
* @since Opale 0.1
*/
public void add(DVect v)
	{
	//if ( n != v.n) 
	//	throws ...;
	
	int i;
	
	for(i=0;i<n;i++)
		x[i]+=v.x[i];
	}		
	
/**
* Soustrait un vecteur.
* @param DVect v, le vecteur  soustraire.
* @since Opale 0.1
*/
public void sub(DVect v)
	{
	//if (n != v.n) 
	//	throws ...;
	
	int i;
	
	for(i=0;i<n;i++)
		x[i]-=v.x[i];
	}		


public void acc(DVect v, double a)
	{
	//if ( n != v.n) 
	//	throws ...;
	
	int i;
	
	for(i=0;i<n;i++)
		x[i]+=a*v.x[i];
	}		


/**
* Multiplie les composantes par un rel.
* @param double a, le rel  multiplier.
* @since Opale 0.1
*/
public void mul(double a)
	{
	int i;
	
	for(i=0;i<n;i++)
		x[i]*=a;
	}		

/**
* Renvoie la norme 2 au carr du vecteur.
* @return double, le carre de la norme.
* @since Opale 0.1
*/
public double norm2Sq()
	{
	int i;
	double s=0;
	for(i=0;i<n;i++)
		s+=x[i]*x[i];
	return s;
	}		
	
/**
* Renvoie la norme 2 du vecteur.
* @return double, la norme.
* @since Opale 0.1
*/
public double norm2()
	{
	return Math.sqrt(norm2Sq());
	}

/**
* Renvoie la norme 1 du vecteur.
* @return double, la norme.
* @since Opale 0.1
*/
public double norm1()
	{
	int i;
	double s=0;
	for(i=0;i<n;i++)
		s+=Math.abs(x[i]);
	return s;
	}		


/**
* Renvoie la norme p du vecteur.
* @param int p, l'indice de la norme voulue.
* @return double, la norme.
* @since Opale 0.1
*/
public double normp(int p)
	{
	if (p == 0)
		return -1;
	else 
		{
		int i;
		double s=0;
		for(i=0;i<n;i++)
			s+=Math.pow(Math.abs(x[i]),p);
		return Math.pow(s,1./p);
		}
	}
	
/**
* Renvoie le maximum des valeurs des composantes.
* @return double max, le maximum.
* @since Opale 0.1
*/
public double getMax()
	{
	return Sort.getMax(n,x);
	}
	
/**
* Renvoie le minimum des valeurs des composantes.
* @return double min, le minimum.
* @since Opale 0.1
*/
public double getMin()
	{
	return Sort.getMin(n,x);
	}
	
			
}

