/*
 * Decompiled with CFR 0.152.
 */
package opale.module2d.noyau2d;

import java.awt.Color;
import java.io.IOException;
import opale.module2d.noyau2d.MalformedFileException;
import opale.module2d.noyau2d.Pack2D;
import opale.tools.RFile;
import opale.tools.WFile;

public class InfoObject
implements Cloneable {
    private String name;
    private Color color;
    private boolean visible;

    public InfoObject() {
        this.color = Color.black;
        this.name = new String("Sans nom");
        this.visible = true;
    }

    public InfoObject(InfoObject infoObject) {
        this.color = infoObject.getColor();
        this.name = new String(infoObject.getName());
        this.visible = infoObject.isVisible();
    }

    public Object clone() {
        try {
            return (InfoObject)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Color getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void readFile(RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        int n = rFile.next();
        if (n != RFile.RF_STRING || !rFile.sval.equals("{")) {
            throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format !!");
        }
        n = rFile.next();
        do {
            if (rFile.sval.equals("NAME")) {
                n = rFile.next();
                if (n != RFile.RF_STRING) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : erreur \u00e0 la lecture du nom d'un objet graphique");
                }
                this.name = rFile.sval;
                continue;
            }
            if (rFile.sval.equals("COLOR")) {
                n = rFile.next();
                if (n != RFile.RF_DOUBLE) {
                    throw new MalformedFileException("Erreur \u00e0 la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
                }
                int n2 = (int)rFile.dval;
                n = rFile.next();
                if (n != RFile.RF_DOUBLE) {
                    throw new MalformedFileException("Erreur \u00e0 la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
                }
                int n3 = (int)rFile.dval;
                n = rFile.next();
                if (n != RFile.RF_DOUBLE) {
                    throw new MalformedFileException("Erreur \u00e0 la lecture de la couleur d'un objet graphique : on attendait les valeurs R G B");
                }
                int n4 = (int)rFile.dval;
                this.color = new Color(n2, n3, n4);
                continue;
            }
            if (rFile.sval.equals("VISIBLE")) {
                n = rFile.next();
                if (n != RFile.RF_STRING) {
                    throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : erreur \u00e0 la lecture de la visibilit\u00e9 d'un objet graphique");
                }
                if (rFile.sval.equals("YES")) {
                    this.setVisible();
                    continue;
                }
                if (rFile.sval.equals("NO")) {
                    this.setUnvisible();
                    continue;
                }
                throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : erreur \u00e0 la lecture de la visibilit\u00e9 d'un objet graphique. On attendait YES ou NO");
            }
            if (this.readKeyWord(rFile.sval, rFile, pack2D) != -1) continue;
            throw new MalformedFileException("Fichier de donn\u00e9es au mauvais format : erreur de lecture d'un mot cl\u00e9 !!");
        } while ((n = rFile.next()) != RFile.RF_STRING || !rFile.sval.equals("}"));
    }

    public int readKeyWord(String string, RFile rFile, Pack2D pack2D) throws IOException, MalformedFileException {
        return -1;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public void setName(String string) {
        this.name = new String(string);
    }

    public void setUnvisible() {
        this.visible = false;
    }

    public void setVisible() {
        this.visible = true;
    }

    public void writeFile(WFile wFile, Pack2D pack2D) {
        wFile.writeln("INFO");
        wFile.writeln("\t{");
        wFile.writeln("\tNAME " + this.name);
        wFile.writeln("\tCOLOR " + this.color.getRed() + " " + this.color.getGreen() + " " + this.color.getBlue());
        if (!this.visible) {
            wFile.writeln("\tVISIBLE NO");
        }
        this.writeFileMore(wFile, pack2D);
        wFile.writeln("\t}");
    }

    public void writeFileMore(WFile wFile, Pack2D pack2D) {
    }
}

