#
# Copyright (C) 2003 Dmitry Fedorov <fedorov@inp.nsk.su>
#
# This file is part of Offmirror.
#
# Offmirror is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# Offmirror is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Offmirror; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

package OffMirror::ChangeAttr;

require 5.004;
use strict;

use File::Stat::Bits;
use File::Stat::ModeString;

use FindBin;
use lib "$FindBin::Bin";
use OffMirror::User;


BEGIN
{
    use vars qw($VERSION @ISA @EXPORT @EXPORT_FAIL);

    use Exporter;

    $VERSION = do { my @r = (q$Revision: 1.6 $ =~ /\d+/g); sprintf "%d."."%02d" x $#r, @r };

    @ISA = ('Exporter');

    @EXPORT      = qw( &my_chown &my_chgrp &my_chmod &my_utime );
}


sub my_chown($$)
{
    my ($fname, $user) = @_;

    my $cmd = "chown -h $user $fname";
    if ( system($cmd) != 0 )
    {
	die "can't $cmd: $?";
    }
}


sub my_chgrp($$)
{
    my ($fname, $group) = @_;

    my $cmd = "chgrp -h $group $fname";
    if ( system($cmd) != 0 )
    {
	die "can't $cmd: $?";
    }
}


sub my_chmod($$)
{
    my ($fname, $strmode) = @_;
    my $mode = string_to_mode($strmode) & ALLPERMS;

    chmod ($mode, $fname) == 1
	or warn "can't chmod($fname, ".sprintf("%06o", $mode)."): $!";
}


sub my_utime($$)
{
    my ($fname, $mtime) = @_;

    utime($mtime, $mtime, $fname) == 1
	or warn "can't utime $mtime, $mtime, $fname: $!";
}


1;

