/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.1.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2004,2005 LAGOUCHE Sophie
 * copyright  2004,2005 CREUSE Emmanuel
 * copyright  2006 FACHE Damien
 * copyright  2004,2005,2006 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2004,2005,2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    spmatrix-test belongs to Mathematical Object Libraries (MOL++)
    MOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for sparse matrix-test
#endif

#if !defined (__SPMATRIX_TEST_H)
#define _spmatrix_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__SPMATRIX_H)
#include "../../MOL++/spmatrix.h"
#endif

#if !defined(__AFFICHE_h)
#include "../affiche.h"
#endif

//============================
int test_spmatrix (int detail)
//============================

{

  int result=1;


	spmatrix<double> M(4,5,3), M2;
	bool test = true;
	int size = 0;
	if(M) size = M;
	else test = false;
	if (M2) test = false;

	if (detail) affiche("cast operator () spmatrix -> int", test && size == M.Rows());
	else result *= (test && size == M.Rows());


	if (detail) affiche("operator !", !(!M) && !M2);
	else result *= (!(!M) && !M2);


	if (detail) affiche("rows/columns",(M.Rows() == 4) && (M.Columns() == 5));
	else result *= ((M.Rows() == 4) && (M.Columns() == 5));


	if (detail) affiche("max number of non-zero coefficients per row", M.Row_Elements() == 3);
	else result *= (M.Row_Elements() == 3);



	//Tests operator ()
	M(1,1) = 1.0;
/*	M(2,1) = M(1,2) = 2.53;
	M(3,1) = M(3,2) = M(3,3) = 87.54;
	M(4,4) = M(1,1);
*/
     M(1,2) = 2.53;
     M(2,1) = 2.53;
     M(3,3) = 87.54;
     M(3,2) = 87.54;
     M(3,1) = 87.54;
     M(4,4) = 1.0;

	double k = M(1,2);

	if (detail) affiche("operator (,) return test", k == 2.53);
	else result *= (k == 2.53);


	if (detail){
	  affiche("operator (,) affect test (single)", M(1,1) == 1.0);
	  affiche("operator (,) affect test (chain)", M(3,1) == 87.54);
	}
	else result *= ((M(1,1) == 1.0) && (M(3,1) == 87.54));


	double res = M(1,1) + M(1,2);

/*	if (detail) affiche ("addition between 2 elements", res == 3.53);
	else result *= (res == 3.53);
*/


	vector<long double> v;
	matrix<int> Mint(4,4);
	Mint(1,1) = 5;

	v = Mint(1,1);

	if (detail) affiche("allocation : vector = M(i,j) with M : matrix<int>", v.dim() == 5);
	else result *= (v.dim() == 5);


	vector<long double> v2;
	matrix<double> Mdouble(4,4);
	Mdouble(1,1) = 5.0;

	v2 = Mdouble(1,1);

	if (detail) affiche("allocation : vector = M(i,j) with M : matrix<double>", v2.dim() == 5);
	else result *= (v2.dim() == 5);


	vector<long double> v3;
	symmatrix<int> Sint(4,4);
	Sint(1,1) = 5;

	v3 = Sint(1,1);

	if (detail) affiche("allocation : vector = M(i,j) with M : symmatrix<int>", v3.dim() == 5);
	else result *= (v3.dim() == 5);


	vector<long double> v4;
	symmatrix<double> Sdouble(4,4);
	Sdouble(1,1) = 5.0;

	v4 = Sdouble(1,1);

	if (detail) affiche("allocation : vector = M(i,j) with M : symmatrix<double>", v4.dim() == 5);
	else result *= (v4.dim() == 5);


	vector<long double> v5;
	spmatrix<int> SPint(4,4,3);
	SPint(1,1) = 5;

	v5 = SPint(1,1);

	if(detail) affiche("allocation : vector = M(i,j) with M : spmatrix<int>", v5.dim() == 5);
	else result *= (v5.dim() == 5);


	vector<long double> v6;
	spmatrix<double> SPdouble(4,4,3);
	SPdouble(1,1) = 5.5;

	v6 = SPdouble(1,1);

	if(detail) affiche("allocation : vector = M(i,j) with M : spmatrix<double>", v6.dim() == 5);
	else result *= (v6.dim() == 5);






	//Tests operator ==

	//with spmatrix
	spmatrix<double> M3(4,5,3), M4(3,5,3), M5(4,4,3), M6(4,5,2);
	M3(1,1) = 1.0;
	M3(1,2) = 2.53;
	M3(2,1) = 2.53;
	M3(3,1) = 87.54;
	M3(3,2) = 87.54;
	M3(3,3) = 87.54;
	M3(4,4) = 1.0;

	if (detail) affiche("operator == spmat/spmat", (M == M3) && (M == M) && !(M == M4) && !(M == M5) && !(M == M6));
	else result *= ((M == M3) && (M == M) && !(M == M4) && !(M == M5) && !(M == M6));


	//with matrix
	matrix<double> Mat(4,5), Mat2(3,5);
	Mat(1,1) = 1.0;
	Mat(1,2) = 2.53;
	Mat(2,1) = 2.53;
	Mat(3,1) = 87.54;
	Mat(3,2) = 87.54;
	Mat(3,3) = 87.54;
	Mat(4,4) = 1.0;

	if (detail) affiche("operator == mat/spmat", (Mat == M) && (Mat2 == M4) && !(Mat == M4));
	else result *= ((Mat == M) && (Mat2 == M4) && !(Mat == M4));


	if (detail) affiche("operator == spmat/mat", (M == Mat) && (M4 == Mat2) && !(M4 == Mat));
	else result *= ((M3 == Mat) && (M4 == Mat2) && !(M4 == Mat));


	//with symmatrix
	spmatrix<double> M7(5,5,2), M8(5,5,2), M9(4,4,1);
	symmatrix<double> Sym(5), Sym2(4);
	M7(1,1) = 5.0; M7(1,2) = 9.0;
	M7(2,1) = 9.0; M7(2,5) = -6.0;
	M7(4,4) = 10.0;
	M7(5,2) = -6.0;

	Sym(1,1) = 5.0;
	Sym(2,1) = 9.0;
	Sym(4,4) = 10.0;
	Sym(5,2) = -6.0;

	if (detail) affiche("operator == symmat/spmat", (Sym == M7) && !(Sym == M8) && (Sym2 == M9));
	else result *= ((Sym == M7) && !(Sym == M8) && (Sym2 == M9));


	if (detail) affiche("operator == spmat/symmat", (M7 == Sym) && !(M8 == Sym) && (M9 == Sym2));
	else result *= ((M7 == Sym) && !(M8 == Sym) && (M9 == Sym2));







	//Tests operator !=

	//with spmatrix
	if (detail) affiche("operator != spmat/spmat", !(M != M3) && !(M != M) && (M != M4) && (M != M5) && (M != M6));
	else result *= (!(M != M3) && !(M != M) && (M != M4) && (M != M5) && (M != M6));


	//with matrix
	if (detail) affiche("operator != mat/spmat", !(Mat != M) && !(Mat2 != M4) && (Mat != M4));
	else result *= (!(Mat != M) && !(Mat2 != M4) && (Mat != M4));


	if (detail) affiche("operator != spmat/mat", !(M != Mat) && !(M4 != Mat2) && (M4 != Mat));
	else result *= (!(M != Mat) && !(M4 != Mat2) && (M4 != Mat));


	//with symmatrix
	if (detail) affiche("operator != symmat/spmat", !(Sym != M7) && (Sym != M8) && !(Sym2 != M9));
	else result *= (!(Sym != M7) && (Sym != M8) && !(Sym2 != M9));


	if (detail) affiche("operator != spmat/symmat", !(M7 != Sym) && (M8 != Sym) && !(M9 != Sym2));
	else result *= (!(M7 != Sym) && (M8 != Sym) && !(M9 != Sym2));







	//Tests constructors
	spmatrix<double> A;

	if (detail) affiche("default constructor", (A.Rows() == 0) && (A.Columns() == 0) && (A.Row_Elements() == 0));
	else result *= ((A.Rows() == 0) && (A.Columns() == 0) && (A.Row_Elements() == 0));


	spmatrix<double> B(4,6,3);

	if(detail) affiche("constructor (int,int,int)", (B.Rows() == 4) && (B.Columns() == 6) && (B.Row_Elements() == 3));
	else result *= ((B.Rows() == 4) && (B.Columns() == 6) && (B.Row_Elements() == 3));


	spmatrix<double> C = M;

	if (detail) affiche("copy constructor", C == M);
	else result *= (C == M);


	spmatrix<double> D =& B;

	if (detail) affiche("copy constructor for temporary objects", (D.Rows() == 4) && (D.Columns() == 6) && (D.Row_Elements() == 3) && (B.Rows() == 0) && (B.Columns() == 0) && (B.Row_Elements() == 0));
	else result *= ((D.Rows() == 4) && (D.Columns() == 6) && (D.Row_Elements() == 3) && (B.Rows() == 0) && (B.Columns() == 0) && (B.Row_Elements() == 0));





	//Tests operators = and &= (=& and &=& also)

	//operator =
	spmatrix<double> E(4,5,3), E2(4,5,3);

	E = E2 = M;

	if (detail) affiche("operator = spmat/spmat", (E == M) && (E2 == M) && M && E2);
	else result *= ((E == M) && (E2 == M) && M && E2);


	//Compatibility with matrix
	matrix<double> MAT(4,5), MAT2(4,5), MAT3 = M;

	MAT = MAT2 = M;

	if (detail) affiche("operator = mat/spmat", (MAT == M) && (MAT2 == M) && (MAT3 == M) && M && MAT2);
	else result *= ((MAT == M) && (MAT2 == M) && (MAT3 == M) && M && MAT2);


	//Compatibility with symmatrix
	spmatrix<double> S(4,4,3);
	symmatrix<double> S1(4), S2(4), Sres(4);
	S(1,1) = 5.0;
	S(2,1) = 3.0; S(2,2) = -1.0;
	S(3,2) = 4.0;
	S(4,1) = 9.0; S(4,2) = 0.1; S(4,4) = -7.0;
	Sres(1,1) = 5.0;
	Sres(2,1) = 3.0; Sres(2,2) = -1.0;
	Sres(3,2) = 4.0;
	Sres(4,1) = 9.0; Sres(4,2) = 0.1; Sres(4,4) = -7.0;

	S1 = S2 = S;

	if (detail) affiche("operator = symmat/spmat", S1 == Sres && S2 == Sres && S && S2);
	else result *= (S1 == Sres && S2 == Sres && S && S2);


	//operator =&
	spmatrix<double> F(4,5,3);

	F =& E;

	if (detail) affiche("operator = (destructive for temporary objects)", !E && (F == M));
	else result *= (!E && (F == M));


	//operator &=
	spmatrix<double> G(3,10,2);

	F &= A;
	A &= G &= M;

	if (detail) affiche("operator &= spmat/spmat", !F && (G == M) && (A == M));
	else result *= (!F && (G == M) && (A == M));


	//operator &=&
	spmatrix<double> H(9,9,3), I(2,2,1);

	H &=& A;

	if (detail) affiche("operator &= (destructive for temporary objects)", !A && (H == M));
	else result *= (!A && (H == M));





	//Tests operator +

	//with spmatrix
	//Test M + 0
	spmatrix<int> Ad1(2,4,2), Ad2(2,4,1), Ad;
	Ad1(1,2) = 2;
	Ad1(1,3) = 1;
	Ad1(2,1) = 1;
	Ad1(2,4) = 2;

	Ad = Ad1 + Ad2;

	bool ad1 = true;
	for(int i=1 ; i<=2 ; i++)
		for(int j=1 ; j<=4 ; j++)
			ad1 *= (abs(Ad(i,j) - Ad1(i,j)) < epsilon);


	//Test 0 + M
	Ad = Ad2 + Ad1;

	bool ad2 = true;
	for(int i=1 ; i<=2 ; i++)
		for(int j=1 ; j<=4 ; j++)
			ad2 *= (abs(Ad(i,j) - Ad1(i,j)) < epsilon);


	//Test 0 + 0
	spmatrix<int> Ad3(1,9,1), Ad4(1,9,1), Ad5(1,9,1);

	Ad &= Ad3 + Ad4;

	bool ad3 = true;
	for(int i=1 ; i<=9 ; i++)
		ad3 *= (abs(Ad(1,i) - Ad5(1,i)) < epsilon);


	//Test for frequent cases
	spmatrix<double> T3(2,10,2), T4(2,10,5), T6(2,10,2), T7(2,10,1), TRES(2,10,3);
	T3(1,3) = 1.0; T3(1,5) = 2.0;
	T3(2,1) = 3.0; T3(2,5) = 4.0;

	T4(1,1) = 1.0; T4(1,3) = 2.0; T4(1,5) = -2.0; T4(1,7) = 4.0; T4(1,8) = 4.0;
	T4(2,1) = 2.0; T4(2,4) = 5.0; T4(2,10) = 3.55;

	T6(1,7) = -4.0; T6(1,8) = 4.0;
	T6(2,1) = -5.0; T6(2,10) = -3.55;

	T7(1,1) = 0.01;


	TRES(1,1) = 1.01; TRES(1,3) = 3.0; TRES(1,8) = 8.0;
	TRES(2,4) = 5.0; TRES(2,5) = 4.0; TRES(2,10) = -7.10;

	T4 &= ((T3 + T4) + T6) + T7;

	bool ad4 = true;
	for(int i=1 ; i<=2 ; i++)
		for(int j=1 ; j<=5 ; j++)
			ad4 *= (abs(T4(i,j) - TRES(i,j)) < epsilon);


	if (detail) affiche("operator + spmat/spmat", ad1 && ad2 && ad3 && ad4);
	else result *= (ad1 && ad2 && ad3 && ad4);



	//with matrix
	matrix<double> X, Xmat(5,5), Xres(5,5);
	spmatrix<double> Xsp(5,5,2);
	symmatrix<double> Xsym(5);

	for(int i=1 ; i<=5 ; i++)
		for(int j=1 ; j<=5 ; j++){
		Xmat(i,j) = -2.0;
		Xres(i,j) = -2.0;
		}
	Xmat(2,2) = 15.0;
	Xsp(1,1) = 50.0; Xsp(1,5) = 52.0; Xsp(2,2) = 50.0; Xsp(3,3) = 50.0; Xsp(5,4) = 99.9;
	Xres(1,1) = 48.0; Xres(1,5) = 50.0; Xres(2,2) = 65.0; Xres(3,3) = 48.0; Xres(5,4) = 97.9;

	X = Xmat + Xsp;

	if(detail) affiche("operator + mat/spmat", X == Xres);
	else result *= (X == Xres);


	X = Xsp + Xmat;

	if (detail) affiche("operator + spmat/mat", X == Xres);
	else result *= (X == Xres);


	//with symmatrix
	Xsym(1,1) = 1.0;
	Xsym(2,2) = 3.0;
	Xsym(3,1) = 2.0; Xsym(3,2) = -2.0;
	Xsym(4,1) = 1.0; Xsym(4,2) = 5.0; Xsym(4,4) = 3.0;
	Xsym(5,3) = -1.0; Xsym(5,5) = 4.0;

	Xres(1,1) = 51.0; Xres(1,2) = 0.0; Xres(1,3) = 2.0; Xres(1,4) = 1.0; Xres(1,5) = 52.0;
	Xres(2,1) = 0.0; Xres(2,2) = 53.0; Xres(2,3) = -2.0; Xres(2,4) = 5.0; Xres(2,5) = 0.0;
	Xres(3,1) = 2.0; Xres(3,2) = -2.0; Xres(3,3) = 50.0; Xres(3,4) = 0.0; Xres(3,5) = -1.0;
	Xres(4,1) = 1.0; Xres(4,2) = 5.0; Xres(4,3) = 0.0; Xres(4,4) = 3.0; Xres(4,5) = 0.0;
	Xres(5,1) = 0.0; Xres(5,2) = 0.0; Xres(5,3) = -1.0; Xres(5,4) = 99.9; Xres(5,5) = 4.0;


	X = Xsp + Xsym;

	if (detail) affiche("operator + spmat/symmat", X == Xres);
	else result *= (X == Xres);


	X = Xsym + Xsp;

	if (detail) affiche("operator + symmat/spmat", X == Xres);
	else result *= (X == Xres);








	//Tests operator -

	//with spmatrix
	//Test M - 0
	spmatrix<double> Nul(4,5,1), ReS;

	ReS = M - Nul;

	bool ad5 = true;
	for(int i=1 ; i<=4 ; i++)
		for(int j=1 ; j<=5 ; j++)
			ad5 *= (abs(ReS(i,j) - M(i,j)) < epsilon);


	//Test 0 - M
	ReS &= Nul - M;

	bool ad6 = true;
	for(int i=1 ; i<= 4 ; i++)
		for(int j=1 ; j<=5 ; j++)
			ad6 *= (abs(ReS(i,j) + M(i,j)) < epsilon);

	
	//Test 0 - 0
	spmatrix<double> T8(2,6,1), T9(2,6,1), T10(2,6,1);

	ReS &= T8 - T9;

	bool ad7 = true;
	for(int i=1 ; i<=2 ; i++)
		for(int j=1 ; j<=6 ; j++)
			ad7 *= (abs(T10(i,j) - ReS(i,j)) < epsilon);


	//Test for frequent cases
	spmatrix<double> T11(4,12,2), T12(4,12,3), T13(4,12,2), T14(4,12,3), TReS(4,12,4);
	T11(1,5) = 9.0; T11(1,10) = 12.0;
	T11(2,3) = 4.4;
	T11(4,4) = 50.0; T11(4,11) = 14.0;

	T12(1,4) = 8.0; T12(1,9) = 11.0;
	T12(2,2) = 3.3;
	T12(4,3) = -60.0; T12(4,8) = 25.0;

	T13(1,9) = -11.0; T13(1,10) = 12.0;
	T13(2,2) = -3.3; T13(2,3) = 4.4;
	T13(4,3) = 60.0; T13(4,8) = -25.0;

	T14(1,4) = 5.0; T14(1,6) = 5.0; T14(1,7) = 90.0;
	T14(2,2) = 2.0;
	T14(3,3) = -5.0;
	T14(4,1) = 1.0; T14(4,2) = -1.0;

	TReS(1,4) = -13.0; TReS(1,5) = 9.0; TReS(1,6) = -5.0; TReS(1,7) = -90.0;
	TReS(2,2) = -2.0;
	TReS(3,3) = 5.0;
	TReS(4,1) = -1.0; TReS(4,2) = 1.0; TReS(4,4) = 50.0; TReS(4,11) = 14.0;

	T12 &= ((T11 - T12) - T13) - T14;

	bool ad8 = true;
	for(int i=1 ; i<=4 ; i++)
		for(int j=1 ; j<=12 ; j++)
			ad8 *= (abs(TReS(i,j) - T12(i,j)) < epsilon);


	if (detail) affiche("operator - spmat/spmat", ad5 && ad6 && ad7 && ad8);
	else result *= (ad5 && ad6 && ad7 && ad8);


	//with matrix
	for(int i=1 ; i<=5 ; i++)
		for(int j=1 ; j<=5 ; j++)
			Xres(i,j) = -2;
	Xres(1,1) = -52.0; Xres(1,5) = -54.0; Xres(2,2) = -35.0; Xres(3,3) = -52.0; Xres(5,4) = -101.9;

	X = Xmat - Xsp;

	if (detail) affiche("operator - mat/spmat", X == Xres);
	else result *= (X == Xres);

	for(int i=1 ; i<=5 ; i++)
		for(int j=1 ; j<=5 ; j++)
			Xres(i,j) = 2.0;
	Xres(1,1) = 52.0; Xres(1,5) = 54.0; Xres(2,2) = 35.0; Xres(3,3) = 52.0; Xres(5,4) = 101.9;


	X = Xsp - Xmat;

	if (detail) affiche("operator - spmat/mat", X == Xres);
	else result *= (X == Xres);


	//with symmatrix
	Xres(1,1) = -49.0; Xres(1,2) = 0.0; Xres(1,3) = 2.0; Xres(1,4) = 1.0; Xres(1,5) = -52.0;
	Xres(2,1) = 0.0; Xres(2,2) = -47.0; Xres(2,3) = -2.0; Xres(2,4) = 5.0; Xres(2,5) = 0.0;
	Xres(3,1) = 2.0; Xres(3,2) = -2.0; Xres(3,3) = -50.0; Xres(3,4) = 0.0; Xres(3,5) = -1.0;
	Xres(4,1) = 1.0; Xres(4,2) = 5.0; Xres(4,3) = 0.0; Xres(4,4) = 3.0; Xres(4,5) = 0.0;
	Xres(5,1) = 0.0; Xres(5,2) = 0.0; Xres(5,3) = -1.0; Xres(5,4) = -99.9; Xres(5,5) = 4.0;

	X = Xsym - Xsp;

	if (detail) affiche("operator - symmat/spmat", X == Xres);
	else result *= (X == Xres);


	Xres(1,1) = 49.0; Xres(1,2) = 0.0; Xres(1,3) = -2.0; Xres(1,4) = -1.0; Xres(1,5) = 52.0;
	Xres(2,1) = 0.0; Xres(2,2) = 47.0; Xres(2,3) = 2.0; Xres(2,4) = -5.0; Xres(2,5) = 0.0;
	Xres(3,1) = -2.0; Xres(3,2) = 2.0; Xres(3,3) = 50.0; Xres(3,4) = 0.0; Xres(3,5) = 1.0;
	Xres(4,1) = -1.0; Xres(4,2) = -5.0; Xres(4,3) = 0.0; Xres(4,4) = -3.0; Xres(4,5) = 0.0;
	Xres(5,1) = 0.0; Xres(5,2) = 0.0; Xres(5,3) = 1.0; Xres(5,4) = 99.9; Xres(5,5) = -4.0;

	X = Xsp - Xsym;

	if (detail) affiche("operator - spmat/symmat", X == Xres);
	else result *= (X == Xres);
















	//Tests operator *

	//with spmatrix
	spmatrix<double> U1(3,4,2), U2(4,3,2);
	U1(1,1) = 1.0; U1(1,2) = 2.0;
	U1(2,2) = 3.0; U1(2,3) = 4.0;
	U1(3,3) = 5.0;

	U2(1,1) = 3.0; U2(1,3) = 1.0;
	U2(2,1) = 4.0; U2(2,2) = 2.0;
	U2(3,2) = 3.0;
	U2(4,1) = 1.0; U2(4,3) = -4.0;

	matrix<double> U, U3(3,3);
	U3(1,1) = 11.0; U3(1,2) = 4.0; U3(1,3) = 1.0;
	U3(2,1) = 12.0; U3(2,2) = 18.0;
	U3(3,2) = 15.0;

	U = U1 * U2;

	bool ad9 = true;
	for(int i=1 ; i<=3 ; i++)
		for(int j=1 ; j<=3 ; j++)
			ad9 *= (abs(U3(i,j) - U(i,j)) < epsilon);

	if (detail) affiche("operator * spmat/spmat", ad9);
	else result *= ad9;


	//with matrix
	for(int i=1 ; i<=5 ; i++){
		Xres(i,1) = -100.0; Xres(i,2) = -100.0; Xres(i,3) = -100.0; Xres(i,4) = -199.8; Xres(i,5) = -104.0;
	}
	Xres(2,2) = 750.0;

	X = Xmat * Xsp;

	if (detail) affiche("operator * mat/spmat", X == Xres);
	else result *= (X == Xres);


	for(int j=1 ; j<=5 ; j++){
		Xres(1,j) = -204.0; Xres(2,j) = -100.0; Xres(3,j) = -100.0; Xres(4,j) = 0.0; Xres(5,j) = -199.8;
	}
	Xres(2,2) = 750.0;

	X = Xsp * Xmat;

	if (detail) affiche("operator * spmat/mat", X == Xres);
	else result *= (X == Xres);


	//with symmatrix
	Xres(1,1) = 50.0; Xres(1,2) = 0.0; Xres(1,3) = 100.0; Xres(1,4) = 0.0; Xres(1,5) = 52.0;
	Xres(2,1) = 0.0; Xres(2,2) = 150.0; Xres(2,3) = -100.0; Xres(2,4) = 0.0; Xres(2,5) = 0.0;
	Xres(3,1) = 100.0; Xres(3,2) = -100.0; Xres(3,3) = 0.0; Xres(3,4) = -99.9; Xres(3,5) = 104.0;
	Xres(4,1) = 50.0; Xres(4,2) = 250.0; Xres(4,3) = 0.0; Xres(4,4) = 0.0; Xres(4,5) = 52.0;
	Xres(5,1) = 0.0; Xres(5,2) = 0.0; Xres(5,3) = -50.0; Xres(5,4) = 399.6; Xres(5,5) = 0.0;

	X = Xsym * Xsp;

	if (detail) affiche("operator * symmat/spmat", X == Xres);
	else result *= (X == Xres);


	Xres(1,1) = 50.0; Xres(1,2) = 0.0; Xres(1,3) = 48.0; Xres(1,4) = 50.0; Xres(1,5) = 208.0;
	Xres(2,1) = 0.0; Xres(2,2) = 150.0; Xres(2,3) = -100.0; Xres(2,4) = 250.0; Xres(2,5) = 0.0;
	Xres(3,1) = 100.0; Xres(3,2) = -100.0; Xres(3,3) = 0.0; Xres(3,4) = 0.0; Xres(3,5) = -50.0;
	Xres(4,1) = 0.0; Xres(4,2) = 0.0; Xres(4,3) = 0.0; Xres(4,4) = 0.0; Xres(4,5) = 0.0;
	Xres(5,1) = 99.9; Xres(5,2) = 499.5; Xres(5,3) = 0.0; Xres(5,4) = 299.7; Xres(5,5) = 0.0;

	X = Xsp * Xsym;

	if (detail) affiche("operator * spmat/symmat", X == Xres);
	else result *= (X == Xres);









	//Tests operator * elt/spmat and spmat/elt
	spmatrix<double> Ures(3,4,2);
	Ures(1,1) = 6.0; Ures(1,2) = 12.0;
	Ures(2,2) = 18.0; Ures(2,3) = 24.0;
	Ures(3,3) = 30.0;

	U2 &= 6.0 * U1;

	if (detail) affiche("operator * elt/spmat", U2 == Ures);
	else result *= (U == Ures);

	U2 &= U1 * 6.0;

	spmatrix<double> Utest =& (U1 * 6.0);

	if (detail) affiche("operator * spmat/elt", (U2 == Ures) && (Utest == Ures));
	else result *= ((U == Ures) && (Utest == Ures));




	//Tests operator * vect/spmat and spmat/vect
	vector<double> V1(4), V, Vres(3), V2(3), Vres2(4);
	V1[1] = 3.0; V1[2] = 1.0; V1[3] = 2.0; V1[4] = 4.0;
	Vres[1] = 5.0; Vres[2] = 11.0; Vres[3] = 10.0;

	V = U1 * V1;

	if (detail) affiche("operator * spmat/vect", V == Vres);
	else result *= (V == Vres);

	V2[1] = 5.0; V2[2] = 0.0; V2[3] = -2.0;
	Vres2[1] = 5.0; Vres2[2] = 10.0; Vres2[3] = -10.0; Vres2[4] = 0.0;

	V &= V2 * U1;

	if (detail) affiche("operator * vect/spmat", V == Vres2);
	else result *= (V == Vres2);


	//Tests operator / spmat/elt
	U2 = U2/6.0;

	if (detail) affiche("operator / spmat/elt", U2 == U1);
	else result *= (U2 == U1);






	//Test operator |
	double K, K2;
	spmatrix<double> Psp(5,5,2), Psp1(5,5,1), Psp2(5,5,3);
	Psp(1,2) = 2.0;
	Psp(2,1) = 1.0; Psp(2,4) = 5.0;
	Psp(3,2) = -9.0;
	Psp(4,5) = -11.0;
	Psp(5,2) = -45.0;


	//with spmatrix
	Psp2(1,2) = 5.0; Psp2(1,4) = 2.0;
	Psp2(2,1) = 3.0; Psp2(2,4) = 1.0; Psp2(2,5) = 2.0;
	Psp2(3,1) = 2.0;
	Psp2(5,4) = 4.0;

	K = Psp | Psp2;
	bool op = (K == 18.0);
	K = Psp2 | Psp;
	K2 = Psp1 | Psp2;

	if (detail) affiche("operator | spmat/spmat", op && (K == 18.0) && (K2 == 0.0));
	else result *= (op && (K == 18.0) && (K2 == 0.0));


	//with matrix
	matrix<double> Pm(5,5);
	Pm(1,1) = 1.0; Pm(1,3) = 2.0; Pm(1,4) = 3.0; Pm(1,5) = 4.0;
	Pm(2,2) = 2.0; Pm(2,4) = 1.0; Pm(2,5) = 3.0;
	Pm(3,1) = 4.0; Pm(3,2) = -2.0; Pm(3,3) = -1.0; Pm(3,5) = 2.0;
	Pm(4,1) = 5.0; Pm(4,4) = 9.0; Pm(4,5) = 1.0;
	Pm(5,2) = -2.0; Pm(5,3) = 1.0; Pm(5,4) = -3.0; Pm(5,5) = 5.0;

	K = Pm | Psp;
	K2 = Pm | Psp1;

	if (detail) affiche("operator | mat/spmat", (K == 102.0) && (K2 == 0.0));
	else result *= (K == 102.0) && (K2 == 0.0);


	K = K2 = 0.0;

	K = Psp | Pm;
	K2 = Psp1 | Pm;

	if (detail) affiche("operator | spmat/mat", (K == 102.0) && (K2 == 0.0));
	else result *= (K == 102.0) && (K2 == 0.0);


	//with symmatrix
	symmatrix<double> Psym(5);
	Psym(1,1) = 4.0;
	Psym(2,2) = -1.0; Psym(2,3) = 5.0;
	Psym(3,1) = 1.0; Psym(3,2) = 5.0;
	Psym(4,3) = 2.0; Psym(4,4) = -7.0;
	Psym(5,1) = 3.0; Psym(5,3) = -5.0; Psym(5,4) = -1.0; Psym(5,5) = 2.0;

	K = K2 = 0.0;

	K = Psym | Psp;
	K2 = Psym | Psp1;

	if (detail) affiche("operator | symmat/spmat", (K == -34.0) && (K2 == 0.0));
	else result *= (K == -34.0) && (K2 == 0.0);

	K = K2 = 0.0;

	K = Psp | Psym;
	K2 = Psp1 | Psym;

	if (detail) affiche("operator | spmat/symmat", (K == -34.0) && (K2 == 0.0));
	else result *= (K == -34.0) && (K2 == 0.0);










	//Test operator +=

	//with spmatrix
	spmatrix<double> R1(3,4,2), R2(3,4,1), Rres(3,4,3);
	R1(1,2) = 5.0; R1(1,4) = 2.0; R1(2,1) = 3.0; R1(3,1) = 1.0;

	R2(1,1) = 9.0; R2(2,1) = 4.0; R2(3,1) = -1.0;

	Rres(1,1) = 9.0; Rres(1,2) = 5.0; Rres(1,4) = 2.0; Rres(2,1) = 7.0;

	R1 += R2;

	if (detail) affiche("operator += spmat/spmat",R1 == Rres);
	else result *= (R1 == Rres);


	//with matrix
	spmatrix<double> Rsp(4,4,2);
	matrix<double> Rmat1(4,4), Rmat2(4,4), Rres2(4,4);
	Rsp(1,2) = 5.0; Rsp(1,4) = 3.0; Rsp(2,1) = 5.0; Rsp(3,4) = 90.1; Rsp(4,1) = 3.0; Rsp(4,3) = 90.1;

	Rmat1(1,1) = 1.0; Rmat1(1,3) = 2.0; Rmat1(1,4) = 3.0;
	Rmat1(2,1) = -5.0; Rmat1(2,2) = 1.0; Rmat1(2,3) = -1.0; Rmat1(2,4) = -2.0;
	Rmat1(3,1) = 4.0; Rmat1(3,2) = 3.0; Rmat1(3,4) = 1.0;
	Rmat1(4,1) = -2.0; Rmat1(4,2) = 1.0; Rmat1(4,3) = 2.0; Rmat1(4,4) = -7.0;

	Rres2(1,1) = 1.0; Rres2(1,2) = 5.0; Rres2(1,3) = 2.0; Rres2(1,4) = 6.0;
	Rres2(2,1) = 0.0; Rres2(2,2) = 1.0; Rres2(2,3) = -1.0; Rres2(2,4) = -2.0;
	Rres2(3,1) = 4.0; Rres2(3,2) = 3.0; Rres2(3,3) = 0.0; Rres2(3,4) = 91.1;
	Rres2(4,1) = 1.0; Rres2(4,2) = 1.0; Rres2(4,3) = 92.1; Rres2(4,4) = -7.0;

	Rmat1 += Rsp;

	if (detail) affiche("operator += mat/spmat", (Rmat1 == Rres2) && (Rmat1 != Rmat2));
	else result *= ((Rmat1 == Rres2) && (Rmat1 != Rmat2));


	//with symmatrix
	symmatrix<double> Rsym1(4), Rsym2(4);
	Rsym1(1,1) = 5.0;
	Rsym1(2,2) = -2.0;
	Rsym1(3,1) = 4.0; Rsym1(3,3) = -4.0;
	Rsym1(4,1) = 1.0; Rsym1(4,2) = 3.0; Rsym1(4,3) = -2.0; Rsym1(4,4) = -1.0;

	Rres2(1,1) = 5.0; Rres2(1,2) = 5.0; Rres2(1,3) = 4.0; Rres2(1,4) = 4.0;
	Rres2(2,1) = 5.0; Rres2(2,2) = -2.0; Rres2(2,3) = 0.0; Rres2(2,4) = 3.0;
	Rres2(3,1) = 4.0; Rres2(3,2) = 0.0; Rres2(3,3) = -4.0; Rres2(3,4) = 88.1;
	Rres2(4,1) = 4.0; Rres2(4,2) = 3.0; Rres2(4,3) = 88.1; Rres2(4,4) = -1.0;

	Rsym1 += Rsp;

	if (detail) affiche("operator += symmat/spmat", (Rsym1 == Rres2) && (Rsym1 != Rsym2));
	else result *= ((Rsym1 == Rres2) && (Rsym1 != Rsym2));


	//Test operator -=
	spmatrix<double> R3(3,4,3);
	R3(1,1) = 9.0; R3(1,3) = -2.0; R3(1,4) = 1.0; R3(2,2) = 4.0; R3(3,3) = 9.0; R3(3,4) = 2.0;

	Rres(1,1) = Rres(1,2) = 0.0 ;
	Rres(1,3) = 2.0; Rres(1,4) = -1.0; Rres(2,1) = 4.0; Rres(2,2) = -4.0; Rres(3,1) = -1.0; Rres(3,3) = -9.0; Rres(3,4) = -2.0;

	R2 -= R3;

	if (detail) affiche("operator -= spmat/spmat", R2 == Rres);
	else result *= (R2 == Rres);


	//Test operator *=

	R3 *= 2.0;

	Rres(1,1) = 18.0; Rres(1,3) = -4.0; Rres(1,4) = 2.0; Rres(2,1) = 0.0;  Rres(2,2) = 8.0; Rres(3,1) = 0.0; Rres(3,3) = 18.0; Rres(3,4) = 4.0;

	if (detail) affiche("operator *= spmat/elt", R3 == Rres);
	else result *= (R3 == Rres);



	//Test transposition
	spmatrix<double> tr1(5,5,2), tr2(5,5,2);
	tr1(1,2) = 1.0; tr1(2,1) = 2.0; tr1(2,4) = 3.0; tr1(3,4) = 4.0; tr1(5,2) = 5.0; tr1(5,3) = 6.0;
	tr2(1,2) = 2.0; tr2(2,1) = 1.0; tr2(2,5) = 5.0; tr2(3,5) = 6.0; tr2(4,2) = 3.0; tr2(4,3) = 4.0;

	if (detail) affiche("t", t(tr1) == tr2);
	else result *= (t(tr1) == tr2);




	//Test display for small matrices (rows and columns <= 15)
	M.save("spmatrix.res");
	spmatrix<double> Co(M.Rows(), M.Columns(), M.Row_Elements());
	Co.read("spmatrix.res");

	if (detail) affiche("read/write test 1", Co == M);
	else result *= (Co == M);


	//Test display for giant matrices (rows and columns >= 15)
	spmatrix<int> Test(2,20,3);
	Test(1,3) = 99;
	Test(2,1) = 50;
	Test.save("spmatrix2.res");
	spmatrix<double> Co2(Test.Rows(), Test.Columns(), Test.Row_Elements());
	Co2.read("spmatrix2.res");

	if (detail) affiche("read/write test 2", Co2 == Test);
	else result *= (Co2 == Test);




	spmatrix<double> As1, As2(6,6,2), Cr1;
	As1.assign(6,6,2);

	for(int i=1 ; i<=6 ; i++)
		As1(i,i) = As2(i,i) = 5.0;

	if (detail) affiche("assign", As1 == As2);
	else result *= (As1 == As2);



	spmatrix<double> D1(6,6,1);
	vector<double> DIAG(6);
	DIAG[1] = 5.0; DIAG[2] = 0.0; DIAG[3] = 9.0; DIAG[4] = 0.0; DIAG[5] = 0.0; DIAG[6] = 11.0;

	D1(1,1) = 5.0; D1(2,1) = 4.0; D1(3,3) = 9.0; D1(5,4) = 1.0; D1(6,6) = 11.0;

	if (detail) affiche("diagonal", diagonal(D1) == DIAG);
	else result *= (diagonal(D1) == DIAG);


	spmatrix<int> ID(7,7,1);
	for(int i=1 ; i<=7 ; i++)
		ID(i,i) = 1;

	if (detail) affiche("Id2sp", ID == Id2sp<int>(7));
	else result *= (Id2sp<int>(7) == ID);




	spmatrix<int> TR(7,7,2);
	TR(1,1) = 3; TR(1,3) = 5; TR(2,1) = 7; TR(3,3) = 4; TR(4,2) = 8; TR(4,4) = 9; TR(6,6) = 10; TR(7,7) = 11;

	if (detail) affiche("tr", tr(TR) == 37);
	else result *= (tr(TR) == 37);

	if (detail) affiche("max", max(TR) == 11);
	else result *= (max(TR) == 11);






  //----------------------------------------------------------------------

  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                 spmatrix test passed \n";
  else cout << "                 spmatrix test failed \n";
  cout << "============================================================== \n";

  return result;


}

#endif
