/*  GNU Moe - My Own Editor
    Copyright (C) 2005, 2006 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

class Window
  {
  int _top_line, _height;	// top line and height of window on screen
  Buffer_handle *bhp;

public:
  static const int min_height = 4;
  Window( const int tl, const int h, Buffer_handle & bh, const bool center ) throw();

  Buffer & buffer() const throw() { return bhp->buffer(); }
  Buffer_handle & buffer_handle() const throw() { return *bhp; }
  Point & pointer() const throw() { return bhp->pointer; }

  Point clock_position() const throw();
  Point absolute_cursor() const throw();	// cursor position on screen
  Point relative_cursor() const throw();	// cursor position on window
  int height() const throw() { return _height; }
  int top_line() const throw() { return _top_line; }

  void center_cursor() throw();
  void goto_bof() throw();
  void goto_eof() throw();
  void goto_home() throw();
  void goto_eol() throw();
  void goto_begin_of_block() throw();
  void goto_end_of_block() throw();
  void goto_line() throw();
  void goto_column() throw();
  void goto_mark( const int i ) throw();
  void goto_matching_delimiter( const bool forward = true ) throw();
  void goto_pnext() throw();
  void goto_pprev() throw();
  void move_page( const bool down ) throw();
  void move_vertical( const int lines ) throw();
  void scroll_horizontal( const int cols ) throw();
  void scroll_page( const bool down ) throw();
  void scroll_vertical( const int lines ) throw();

  void set_mark( const int i ) throw();

  void repaint() const throw();
  void show_character_info() const throw();
  void show_status_line( const char * prefix = 0 ) const throw();

  enum From { from_top_left, from_cursor, from_pointer };
  void update_points( const Point & to, const bool show = true,
                      bool center = false, const From from = from_pointer ) throw();
  };
