/*  GNU Moe - My Own Editor
    Copyright (C) 2005 Antonio Diaz Diaz.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
*/

namespace File {

// 'name' contains the filename to be modified (may be empty).
// Returns false if aborted.
//
bool file_menu( const std::string & prompt, std::string & name ) throw();


// 'name' contains the default result (may be empty), and
// stores the result (if any).
// Returns the size of the result string, 0 if none, -1 if aborted.
// 'name' is cleared if aborted.
//
int get_filename( const std::string & prompt, std::string & name ) throw();


bool is_regular( const std::string & name, const bool quiet = false ) throw();

bool make_path( const std::string & name ) throw();

const std::string & my_basename( const std::string & name ) throw();

bool test_slash_filename( std::string & name ) throw();

} // end namespace File


namespace Help {

void help_menu( int help_key ) throw();

} // end namespace Help


namespace Menu {

void options_menu( Buffer & buffer, const int menu_key ) throw();

} // end namespace Menu
