// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023,2024,2025 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// @file post_processor.cpp C++ API <i>mobius.framework.ant.post_processor</i> class wrapper
// @author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <pymobius.hpp>
#include "post_processor.hpp"
#include <stdexcept>
#include "ant.hpp"
#include "framework/model/item.hpp"

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// @brief <i>post_processor</i> Constructor
// @param type Type object
// @param args Argument list
// @param kwds Keywords dict
// @return new <i>post_processor</i> object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
tp_new (PyTypeObject *type, PyObject *args, PyObject *)
{
    // Parse input args
    mobius::framework::model::item arg_item;

    try
        {
            arg_item = mobius::py::get_arg_as_cpp (args, 0, pymobius_framework_model_item_from_pyobject);
        }
    catch (const std::exception& e)
        {
            mobius::py::set_invalid_type_error (e.what ());
            return nullptr;
        }


    // Create Python object
    framework_ant_post_processor_o *ret = reinterpret_cast <framework_ant_post_processor_o *> (type->tp_alloc (type, 0));

    if (ret)
        {
            try
            {
                ret->obj = new mobius::framework::ant::post_processor (arg_item);
            }
            catch (const std::exception& e)
            {
                Py_DECREF (ret);
                mobius::py::set_runtime_error (e.what ());
                ret = nullptr;
            }
        }

    return reinterpret_cast <PyObject *> (ret);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// @brief <i>post_processor</i> deallocator
// @param self Object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
tp_dealloc (framework_ant_post_processor_o *self)
{
    delete self->obj;
    Py_TYPE (self)->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// @brief Type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyTypeObject framework_ant_post_processor_t =
{
    PyVarObject_HEAD_INIT (nullptr, 0)       		// header
    "mobius.framework.ant.post_processor",   		// tp_name
    sizeof (framework_ant_post_processor_o), 		// tp_basicsize
    0,                                       		// tp_itemsize
    (destructor) tp_dealloc,                 		// tp_dealloc
    0,                                       		// tp_print
    0,                                       		// tp_getattr
    0,                                       		// tp_setattr
    0,                                       		// tp_compare
    0,                                       		// tp_repr
    0,                                       		// tp_as_number
    0,                                       		// tp_as_sequence
    0,                                       		// tp_as_mapping
    0,                                       		// tp_hash
    0,                                       		// tp_call
    0,                                       		// tp_str
    0,                                       		// tp_getattro
    0,                                       		// tp_setattro
    0,                                       		// tp_as_buffer
    Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,		// tp_flags
    "post_processor class",                  		// tp_doc
    0,                                       		// tp_traverse
    0,                                       		// tp_clear
    0,                                       		// tp_richcompare
    0,                                       		// tp_weaklistoffset
    0,                                       		// tp_iter
    0,                                       		// tp_iternext
    0,                                       		// tp_methods
    0,                                       		// tp_members
    0,                                       		// tp_getset
    get_framework_ant_ant_type (),            		// tp_base
    0,                                       		// tp_dict
    0,                                       		// tp_descr_get
    0,                                       		// tp_descr_set
    0,                                       		// tp_dictoffset
    0,                                       		// tp_init
    0,                                       		// tp_alloc
    tp_new,                                  		// tp_new
    0,                                       		// tp_free
    0,                                       		// tp_is_gc
    0,                                       		// tp_bases
    0,                                       		// tp_mro
    0,                                       		// tp_cache
    0,                                       		// tp_subclasses
    0,                                       		// tp_weaklist
    0,                                       		// tp_del
    0,                                       		// tp_version_tag
    0,                                       		// tp_finalize
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// @brief Create <i>mobius.framework.ant.post_processor</i> type
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
mobius::py::pytypeobject
new_framework_ant_post_processor_type ()
{
    mobius::py::pytypeobject type (&framework_ant_post_processor_t);
    type.create ();

    return type;
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// @brief Check if value is an instance of <i>post_processor</i>
// @param value Python value
// @return true/false
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
bool
pymobius_framework_ant_post_processor_check (PyObject *value)
{
    return mobius::py::isinstance (value, &framework_ant_post_processor_t);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// @brief Create <i>post_processor</i> Python object from C++ object
// @param obj C++ object
// @return New post_processor object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyObject *
pymobius_framework_ant_post_processor_to_pyobject (const mobius::framework::ant::post_processor& obj)
{
    return mobius::py::to_pyobject <framework_ant_post_processor_o> (obj, &framework_ant_post_processor_t);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// @brief Create <i>post_processor</i> C++ object from Python object
// @param value Python value
// @return Post_processor object
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
mobius::framework::ant::post_processor
pymobius_framework_ant_post_processor_from_pyobject (PyObject *value)
{
    return mobius::py::from_pyobject <framework_ant_post_processor_o> (value, &framework_ant_post_processor_t);
}
