#!/usr/bin/env python3

import mobius
import sys

app = mobius.core.application ()
app.start ()

for uri in sys.argv[1:]:
   print ()
   print (">>", uri)
   print ("     Start         End     Sectors   Flags  Description")

   disk = mobius.disk.new_disk_from_url (uri)

   if disk.is_available ():
     for starting_sector, ending_sector, sectors, etype, flags, description in mobius.partition.get_partition_table (disk):
       print ('%10d  %10d  %10d  %6s  %s' % (starting_sector, ending_sector, sectors, flags, description))

app.stop ()
