#ifndef MOBIUS_CRYPT_HASH_ADLER32_H
#define MOBIUS_CRYPT_HASH_ADLER32_H

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018,2019,2020 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/crypt/hash_stream.h>
#include <cstdint>

namespace mobius
{
namespace crypt
{

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief Adler-32 hash function implementation
//! \author Eduardo Aguiar
//! \see RFC 1950
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class hash_adler32 : public hash_stream
{
public:
  hash_adler32 () noexcept = default;
  void update (const mobius::bytearray&) noexcept final;
  void update_byte (std::uint8_t, std::uint64_t);
  void reset () noexcept final;
  bytearray get_digest () final;

private:
  std::uint32_t a_ = 1;
  std::uint32_t b_ = 0;
};

} // namespace crypt
} // namespace mobius

#endif
