# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017,2018 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import CMatchFile

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Generic data holder
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class dataholder (object):
  pass

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# @brief Decode CMatchList structure
# @see MatchObjects.cpp - CMatchList::Serialize
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
def decode (decoder):
  ml = dataholder ()
  ml.version = decoder.get_dword ()
  ml.filter_name = decoder.get_string ()
  ml.filter_busy = decoder.get_bool ()
  ml.filter_push = decoder.get_bool ()
  ml.filter_unstable = decoder.get_bool ()
  ml.filter_reject = decoder.get_bool ()
  ml.filter_local = decoder.get_bool ()
  ml.filter_bogus = decoder.get_bool ()
  ml.match_files = []

  if ml.version >= 12:
    ml.filter_drm = decoder.get_bool ()
    ml.filter_adult = decoder.get_bool ()
    ml.filter_suspicious = decoder.get_bool ()
    ml.regexp = decoder.get_bool ()
  else:
    ml.filter_drm = False
    ml.filter_adult = False
    ml.filter_suspicious = False
    ml.regexp = False

  if ml.version >= 10:
    ml.filter_min_size = decoder.get_qword ()
    ml.filter_max_size = decoder.get_qword ()
  else:
    ml.filter_min_size = decoder.get_dword ()
    ml.filter_max_size = decoder.get_dword ()

  ml.filter_sources = decoder.get_dword ()
  ml.sort_column = decoder.get_int ()
  ml.sort_dir = decoder.get_bool ()

  count = decoder.get_count ()

  for i in xrange (count):
    mf = CMatchFile.decode (decoder, ml.version)
    ml.match_files.append (mf)

  return ml
