// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief C++ API module wrapper
//! \author Eduardo Aguiar
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include "api_filesystem_vfat.h"
#include "api_datetime.h"
#include <mobius/filesystem/filesystem_vfat.h>

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: tp_dealloc
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static void
api_filesystem_vfat_tp_dealloc (api_filesystem_vfat_o *self)
{
  delete self->obj;
  self->ob_type->tp_free ((PyObject*) self);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: type getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_type (api_filesystem_vfat_o *self)
{
  return PyString_FromString (self->obj->get_type ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: offset getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_offset (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_offset ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_size (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_name (api_filesystem_vfat_o *self)
{
  return PyString_FromString (self->obj->get_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: fs_type getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_fs_type (api_filesystem_vfat_o *self)
{
  return PyString_FromString (self->obj->get_fs_type ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: oem_name getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_oem_name (api_filesystem_vfat_o *self)
{
  return PyString_FromString (self->obj->get_oem_name ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: sector_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_sector_size (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sector_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: sectors_per_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_sectors_per_cluster (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sectors_per_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: reserved_sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_reserved_sectors (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_reserved_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: fats getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_fats (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_fats ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: root_dir_entries getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_root_dir_entries (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_root_dir_entries ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_sectors (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: media_descriptor getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_media_descriptor (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_media_descriptor ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: sectors_per_fat getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_sectors_per_fat (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_sectors_per_fat ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: sectors_per_track getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_sectors_per_track (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_sectors_per_track ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: heads getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_heads (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_heads ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: hidden_sectors getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_hidden_sectors (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_hidden_sectors ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: logical_drive_number getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_logical_drive_number (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_logical_drive_number ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: volume_id getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_volume_id (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_volume_id ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: volume_label getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_volume_label (api_filesystem_vfat_o *self)
{
  return PyString_FromString (self->obj->get_volume_label ().c_str ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: flags getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_flags (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_flags ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: version getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_version (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_version ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: root_dir_cluster getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_root_dir_cluster (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_root_dir_cluster ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: fs_info_sector getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_fs_info_sector (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_fs_info_sector ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: backup_boot_sector getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_backup_boot_sector (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLongLong (self->obj->get_backup_boot_sector ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: fat_entry_size getter
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyObject *
api_filesystem_vfat_getter_fat_entry_size (api_filesystem_vfat_o *self)
{
  return PyLong_FromUnsignedLong (self->obj->get_fat_entry_size ());
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: getters and setters structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
static PyGetSetDef api_filesystem_vfat_getsetters[] =
{
  {
    (char *) "type",
    (getter) api_filesystem_vfat_getter_type,
    (setter) 0,
    (char *) "filesystem type", NULL
  },
  {
    (char *) "offset",
    (getter) api_filesystem_vfat_getter_offset,
    (setter) 0,
    (char *) "offset in bytes", NULL
  },
  {
    (char *) "size",
    (getter) api_filesystem_vfat_getter_size,
    (setter) 0,
    (char *) "filesystem size in bytes", NULL
  },
  {
    (char *) "name",
    (getter) api_filesystem_vfat_getter_name,
    (setter) 0,
    (char *) "name", NULL
  },
  {
    (char *) "fs_type",
    (getter) api_filesystem_vfat_getter_fs_type,
    (setter) 0,
    (char *) "filesystem type", NULL
  },
  {
    (char *) "oem_name",
    (getter) api_filesystem_vfat_getter_oem_name,
    (setter) 0,
    (char *) "OEM name", NULL
  },
  {
    (char *) "sector_size",
    (getter) api_filesystem_vfat_getter_sector_size,
    (setter) 0,
    (char *) "sector size in bytes", NULL
  },
  {
    (char *) "sectors_per_cluster",
    (getter) api_filesystem_vfat_getter_sectors_per_cluster,
    (setter) 0,
    (char *) "sectors per cluster", NULL
  },
  {
    (char *) "reserved_sectors",
    (getter) api_filesystem_vfat_getter_reserved_sectors,
    (setter) 0,
    (char *) "number of reserved sectors", NULL
  },
  {
    (char *) "fats",
    (getter) api_filesystem_vfat_getter_fats,
    (setter) 0,
    (char *) "number of FATs", NULL
  },
  {
    (char *) "root_dir_entries",
    (getter) api_filesystem_vfat_getter_root_dir_entries,
    (setter) 0,
    (char *) "number of entries in root directory", NULL
  },
  {
    (char *) "sectors",
    (getter) api_filesystem_vfat_getter_sectors,
    (setter) 0,
    (char *) "number of sectors", NULL
  },
  {
    (char *) "media_descriptor",
    (getter) api_filesystem_vfat_getter_media_descriptor,
    (setter) 0,
    (char *) "media descriptor type", NULL
  },
  {
    (char *) "sectors_per_fat",
    (getter) api_filesystem_vfat_getter_sectors_per_fat,
    (setter) 0,
    (char *) "sectors per FAT", NULL
  },
  {
    (char *) "sectors_per_track",
    (getter) api_filesystem_vfat_getter_sectors_per_track,
    (setter) 0,
    (char *) "sectors per track", NULL
  },
  {
    (char *) "heads",
    (getter) api_filesystem_vfat_getter_heads,
    (setter) 0,
    (char *) "number of heads", NULL
  },
  {
    (char *) "hidden_sectors",
    (getter) api_filesystem_vfat_getter_hidden_sectors,
    (setter) 0,
    (char *) "number of hidden sectors", NULL
  },
  {
    (char *) "logical_drive_number",
    (getter) api_filesystem_vfat_getter_logical_drive_number,
    (setter) 0,
    (char *) "logical drive number", NULL
  },
  {
    (char *) "volume_id",
    (getter) api_filesystem_vfat_getter_volume_id,
    (setter) 0,
    (char *) "volume ID", NULL
  },
  {
    (char *) "volume_label",
    (getter) api_filesystem_vfat_getter_volume_label,
    (setter) 0,
    (char *) "volume label", NULL
  },
  {
    (char *) "flags",
    (getter) api_filesystem_vfat_getter_flags,
    (setter) 0,
    (char *) "flags", NULL
  },
  {
    (char *) "version",
    (getter) api_filesystem_vfat_getter_version,
    (setter) 0,
    (char *) "filesystem version", NULL
  },
  {
    (char *) "root_dir_cluster",
    (getter) api_filesystem_vfat_getter_root_dir_cluster,
    (setter) 0,
    (char *) "root directory cluster", NULL
  },
  {
    (char *) "fs_info_sector",
    (getter) api_filesystem_vfat_getter_fs_info_sector,
    (setter) 0,
    (char *) "filesystem information sector", NULL
  },
  {
    (char *) "backup_boot_sector",
    (getter) api_filesystem_vfat_getter_backup_boot_sector,
    (setter) 0,
    (char *) "backup boot sector", NULL
  },
  {
    (char *) "fat_entry_size",
    (getter) api_filesystem_vfat_getter_fat_entry_size,
    (setter) 0,
    (char *) "FAT entry size in bits", NULL
  },
  {NULL} // sentinel
};

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//!\brief api_filesystem_vfat: type structure
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
PyTypeObject api_filesystem_vfat_t =
{
  PyObject_HEAD_INIT (0)
  0,                                          		// ob_size
  "api.filesystem_vfat",                      		// tp_name
  sizeof (api_filesystem_vfat_o),             		// tp_basicsize
  0,                                          		// tp_itemsize
  (destructor) api_filesystem_vfat_tp_dealloc,		// tp_dealloc
  0,                                          		// tp_print
  0,                                          		// tp_getattr
  0,                                          		// tp_setattr
  0,                                          		// tp_compare
  0,                                          		// tp_repr
  0,                                          		// tp_as_number
  0,                                          		// tp_as_sequence
  0,                                          		// tp_as_mapping
  0,                                          		// tp_hash
  0,                                          		// tp_call
  0,                                          		// tp_str
  0,                                          		// tp_getattro
  0,                                          		// tp_setattro
  0,                                          		// tp_as_buffer
  Py_TPFLAGS_DEFAULT | Py_TPFLAGS_BASETYPE,   		// tp_flags
  "filesystem_vfat class",                    		// tp_doc
  0,                                          		// tp_traverse
  0,                                          		// tp_clear
  0,                                          		// tp_richcompare
  0,                                          		// tp_weaklistoffset
  0,                                          		// tp_iter
  0,                                          		// tp_iternext
  0,                                          		// tp_methods
  0,                                          		// tp_members
  api_filesystem_vfat_getsetters,             		// tp_getset
  0,                                          		// tp_base
  0,                                          		// tp_dict
  0,                                          		// tp_descr_get
  0,                                          		// tp_descr_set
  0,                                          		// tp_dictoffset
  0,                                          		// tp_init
  0,                                          		// tp_alloc
  0                                           		// tp_new
};
