// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
// Mobius Forensic Toolkit
// Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015,2016,2017 Eduardo Aguiar
//
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2, or (at your option) any later
// version.
//
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
// Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program. If not, see <http://www.gnu.org/licenses/>.
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <mobius/imagefile/imagefile_impl_base.h>
#include <mobius/string_functions.h>

namespace mobius
{
namespace imagefile
{

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief set drive model
//! \param drive_model drive model
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
imagefile_impl_base::set_drive_model (const std::string& drive_model)
{
  // get drive vendor, if any
  size_t pos = drive_model.find (' ');

  if (pos != std::string::npos)
    {
      std::string vendor = drive_model.substr (0, pos);
      set_drive_vendor (vendor);
      ++pos;
    }

  else
    {
      pos = 0;

      if (string_startswith (drive_model, "ST"))
        set_drive_vendor ("Seagate");
    }

  // get drive model
  drive_model_ = drive_model.substr (pos);

  pos = drive_model_.find ('-');

  if (pos != std::string::npos)
    drive_model_.erase (pos);
}

// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief set drive serial number
//! \param drive_serial_number drive serial number
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
void
imagefile_impl_base::set_drive_serial_number (const std::string& drive_serial_number)
{
  // Western Digital serial numbers
  if (string_startswith (drive_serial_number, "WD-"))
    drive_serial_number_ = drive_serial_number.substr (3);

  else
    drive_serial_number_ = drive_serial_number;
}


} // namespace imagefile
} // namespace mobius
