/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   Mobius Forensic Toolkit
   Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= */
#include <mobius/unittest.h>
#include <mobius/crypt/hash_zip.h>
#include <cstring>

const std::string
get_hex_digest (const mobius::crypt::hash_zip& h)
{
  return h.get_digest ().to_hexstring ();
}
 
void
update (mobius::crypt::hash_zip& h, const char *s)
{
  h.update (s, s + strlen (s));
}

void
unittest_hash_zip ()
{
  mobius::unittest test ("mobius::crypt::hash_zip");

  mobius::crypt::hash_zip h1;
  mobius::crypt::hash_zip h2;
  mobius::crypt::hash_zip h3;

  test.ASSERT_EQUAL (get_hex_digest (h1), "123456782345678934567890");
  test.ASSERT_EQUAL (get_hex_digest (h2), "123456782345678934567890");
  test.ASSERT_EQUAL (get_hex_digest (h3), "123456782345678934567890");

  // update
  update (h2, "abc");
  test.ASSERT_EQUAL (get_hex_digest (h2), "5dd2af4d589d03b43cf5ffa4");

  h2.update_byte ('d');
  test.ASSERT_EQUAL (get_hex_digest (h2), "42ef4ac38d167254428e6d93");
  
  update (h3, "abcd");
  test.ASSERT_EQUAL (get_hex_digest (h3), get_hex_digest (h2));

  test.end ();
}
