/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   Mobius Forensic Toolkit
   Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= */
#include <mobius/crypt/cipher_zip.h>
#include <mobius/unittest.h>

void
unittest_cipher_zip ()
{
  mobius::unittest test_01 ("mobius::crypt::cipher_zip");

  // key="Key", Plaintext="Plaintext"
  mobius::crypt::cipher_zip zip_1 ("Key");
  mobius::bytearray b_1 = "Plaintext";

  test_01.ASSERT_EQUAL (b_1.to_hexstring (), "506c61696e74657874");
  zip_1.encrypt (b_1.begin (), b_1.end (), b_1.begin ());
  test_01.ASSERT_EQUAL (b_1.to_hexstring (), "fe1995e4fe54a8c6f3");
  zip_1.reset ();
  zip_1.decrypt (b_1.begin (), b_1.end (), b_1.begin ());
  test_01.ASSERT_EQUAL (b_1.to_hexstring (), "506c61696e74657874");

  // key="Secret", Plaintext="Attack at dawn"
  mobius::crypt::cipher_zip zip_2 ("Secret");
  mobius::bytearray b_2 = "Attack at dawn";

  test_01.ASSERT_EQUAL (b_2.to_hexstring (), "41747461636b206174206461776e");
  zip_2.encrypt (b_2.begin (), b_2.end (), b_2.begin ());
  test_01.ASSERT_EQUAL (b_2.to_hexstring (), "7595da02f5ec5c2c78755fd4069e");
  zip_2.reset ();
  zip_2.decrypt (b_2.begin (), b_2.end (), b_2.begin ());
  test_01.ASSERT_EQUAL (b_2.to_hexstring (), "41747461636b206174206461776e");
  test_01.end ();
}