/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   Mobius Forensic Toolkit
   Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= */
#include <mobius/crypt/cipher_des.h>
#include <mobius/crypt/cipher_block_mode_cbc.h>
#include <mobius/unittest.h>
#include <iostream>

void
unittest_cipher_des ()
{
  // DES - mode ECB
  mobius::crypt::cipher_des des0 ({0x00, 0xe8, 0x03, 0x00, 0x00, 0xe8, 0x03});
  mobius::bytearray b0 = {0x33, 0xb8, 0x17, 0xb0, 0x9b, 0x82, 0xa4, 0xf1};

  mobius::unittest test_01 ("mobius::crypt::cipher_des");
  test_01.ASSERT_EQUAL (b0.to_hexstring (), "33b817b09b82a4f1");

  des0.decrypt (b0.begin (), b0.end (), b0.begin ());
  test_01.ASSERT_EQUAL (b0.to_hexstring (), "f4ed3a422ae3a1a6");

  // DES - mode ECB
  mobius::crypt::cipher_des des1 ({0x13, 0x34, 0x57, 0x79, 0x9b, 0xbc, 0xdf, 0xf1});
  mobius::bytearray b1 = {0x01, 0x23, 0x45, 0x67, 0x89, 0xab, 0xcd, 0xef};

  test_01.ASSERT_EQUAL (b1.to_hexstring (), "0123456789abcdef");

  des1.encrypt (b1.begin (), b1.end (), b1.begin ());
  test_01.ASSERT_EQUAL (b1.to_hexstring (), "85e813540f0ab405");

  des1.decrypt (b1.begin (), b1.end (), b1.begin ());
  test_01.ASSERT_EQUAL (b1.to_hexstring (), "0123456789abcdef");

  // DES - mode ECB
  mobius::crypt::cipher_des des2 ({0x0e, 0x32, 0x92, 0x32, 0xea, 0x6d, 0x0d, 0x73});
  mobius::bytearray b2 (8);
  b2.fill (0x87);

  test_01.ASSERT_EQUAL (b2.to_hexstring (), "8787878787878787");

  des2.encrypt (b2.begin (), b2.end (), b2.begin ());
  test_01.ASSERT_EQUAL (b2.to_hexstring (), "0000000000000000");

  des2.decrypt (b2.begin (), b2.end (), b2.begin ());
  test_01.ASSERT_EQUAL (b2.to_hexstring (), "8787878787878787");

  // LM password "ABCD123"
  mobius::crypt::cipher_des des3 ("ABCD123");
  mobius::bytearray b3 ("KGS!@#$%");

  test_01.ASSERT_EQUAL (b3.to_hexstring (), "4b47532140232425");

  des3.encrypt (b3.begin (), b3.end (), b3.begin ());
  test_01.ASSERT_EQUAL (b3.to_hexstring (), "6f87cd328120cc55");

  des3.decrypt (b3.begin (), b3.end (), b3.begin ());
  test_01.ASSERT_EQUAL (b3.to_hexstring (), "4b47532140232425");

  // LM password "ABCDE12"
  mobius::crypt::cipher_des des4 ("ABCDE12");
  mobius::bytearray b4 ("KGS!@#$%");

  test_01.ASSERT_EQUAL (b4.to_hexstring (), "4b47532140232425");

  des4.encrypt (b4.begin (), b4.end (), b4.begin ());
  test_01.ASSERT_EQUAL (b4.to_hexstring (), "722ac01404a75156");

  des4.decrypt (b4.begin (), b4.end (), b4.begin ());
  test_01.ASSERT_EQUAL (b4.to_hexstring (), "4b47532140232425");

  // DES - mode CBC
  mobius::crypt::cipher_des des5 ("ABCDE12", new mobius::crypt::cipher_block_mode_cbc ({0, 0, 0, 0, 0, 0, 0, 0}));
  mobius::bytearray b5 ("KGS!@#$%");
  
  test_01.ASSERT_EQUAL (b5.to_hexstring (), "4b47532140232425");

  des5.encrypt (b5.begin (), b5.end (), b5.begin ());
  test_01.ASSERT_EQUAL (b5.to_hexstring (), "722ac01404a75156");

  des5.reset ();
  des5.decrypt (b5.begin (), b5.end (), b5.begin ());
  test_01.ASSERT_EQUAL (b5.to_hexstring (), "4b47532140232425");

  // DES - mode ECB
  mobius::crypt::cipher_des des6 ({0xe7, 0x37, 0x4e, 0x45, 0x8d, 0x54, 0xfd});
  mobius::bytearray b6 = {0x75, 0x3f, 0x61, 0x59, 0xc3, 0xa3, 0x11, 0x49};

  test_01.ASSERT_EQUAL (b6.to_hexstring (), "753f6159c3a31149");

  des6.decrypt (b6.begin (), b6.end (), b6.begin ());
  test_01.ASSERT_EQUAL (b6.to_hexstring (), "0000000001000000");

  // DES - mode CBC
  mobius::crypt::cipher_des des7 ({0x17,0xc0,0xfc,0x69,0x31,0x10,0xcb,0xd7}, new mobius::crypt::cipher_block_mode_cbc ({0, 0, 0, 0, 0, 0, 0, 0}));
  mobius::bytearray b7 ({0x62 ,0x75 ,0x32 ,0xeb ,0xd7 ,0x97 ,0xe0 ,0xfe ,0x7d ,0xf4 ,0x7c ,0x02 ,0xa5 ,0x12 ,0x61 ,0x3e ,0x9f ,0xdb ,0xd3 ,0x7e ,0x8b ,0x89 ,0x2d ,0xc1});

  test_01.ASSERT_EQUAL (b7.to_hexstring (), "627532ebd797e0fe7df47c02a512613e9fdbd37e8b892dc1");

  des7.decrypt (b7.begin (), b7.end (), b7.begin ());
  test_01.ASSERT_EQUAL (b7.to_hexstring (), "e5a3ac4e83fa5862f59f5773981c70030808080808080808");

  test_01.end ();
}