#ifndef __MOBIUS_CRYPT_CIPHER_ZIP_H__
#define __MOBIUS_CRYPT_CIPHER_ZIP_H__
/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   Mobius Forensic Toolkit
   Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= */
#include <cstdint>
#include <mobius/bytearray.h>
#include <mobius/crypt/cipher_stream.h>

namespace mobius
{
namespace crypt
{
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//! \brief zip archive stream cipher algorithm
//! \author Eduardo Aguiar
//! \see https://www.pkware.com/documents/casestudies/APPNOTE.TXT
// =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
class cipher_zip : public cipher_stream
{
public:
  cipher_zip (const mobius::bytearray&);
  virtual void reset ();

private:
  mobius::bytearray key_;
  std::uint32_t k0_, k1_, k2_;

  virtual std::uint8_t _encrypt_byte (std::uint8_t);
  virtual std::uint8_t _decrypt_byte (std::uint8_t);
  void _update_keys (std::uint8_t);
};

} // namespace crypt
} // namespace mobius

#endif
