/* =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
   Mobius Forensic Toolkit
   Copyright (C) 2008,2009,2010,2011,2012,2013,2014,2015 Eduardo Aguiar

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any later
   version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
   Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program. If not, see <http://www.gnu.org/licenses/>.
   =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= */
#include <mobius/crypt/hash_crc32.h>
#include <mobius/unittest.h>
#include <cstring>

const std::string
get_hex_digest (const mobius::crypt::hash_crc32& h)
{
  return h.get_digest ().to_hexstring ();
}

void
update (mobius::crypt::hash_crc32& h, const char *s)
{
  h.update (s, s + strlen (s));
}

void
unittest_hash_crc32 ()
{
  mobius::unittest test ("mobius::crypt::hash_crc32");

  mobius::crypt::hash_crc32 h1;
  mobius::crypt::hash_crc32 h2;
  mobius::crypt::hash_crc32 h3;

  test.ASSERT_EQUAL (get_hex_digest (h1), "00000000");
  test.ASSERT_EQUAL (get_hex_digest (h2), "00000000");
  test.ASSERT_EQUAL (get_hex_digest (h3), "00000000");

  // update
  update (h2, "abc");
  test.ASSERT_EQUAL (get_hex_digest (h2), "352441c2");

  h2.update_byte ('d');
  test.ASSERT_EQUAL (get_hex_digest (h2), "ed82cd11");
  
  update (h3, "abcd");
  test.ASSERT_EQUAL (get_hex_digest (h3), get_hex_digest (h2));

  test.end ();
}
