# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
# Mobius Forensic Toolkit
# Copyright (C) 2008 Eduardo Aguiar
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by the
# Free Software Foundation; either version 2, or (at your option) any later
# version.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General
# Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
import gtk
import gtk.gdk
import mobius

(CATEGORY_ICON, CATEGORY_NAME, CATEGORY_OBJECT) = range (3)

# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
# @brief Add item dialog
# =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
class Dialog (gtk.Dialog):

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  # Build widget
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
  def __init__ (self, *args):
    gtk.Dialog.__init__ (self, 'Add item', None, gtk.DIALOG_MODAL,
       (gtk.STOCK_OK, gtk.RESPONSE_OK, gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL))
    self.set_position (gtk.WIN_POS_CENTER)
    self.set_size_request (400, 300)
    self.set_type_hint (gtk.gdk.WINDOW_TYPE_HINT_DIALOG)
    self.set_border_width (10)
    self.vbox.set_spacing (5)

    # datastore
    datastore = gtk.ListStore (gtk.gdk.Pixbuf, str, object)
    categories = mobius.mediator.call ('category.get-list')
    #categories.sort ()

    for category in categories:
      loader = gtk.gdk.PixbufLoader ()
      loader.set_size (32, 32)
      loader.write (category.icon_data.decode ('base64'))
      loader.close ()
      category.icon = loader.get_pixbuf ()

      datastore.append ((category.icon, category.name, category))

    # listview
    sw = gtk.ScrolledWindow ()
    sw.set_policy (gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
    sw.show ()
    self.vbox.pack_start (sw)

    listview = gtk.TreeView (datastore)
    listview.set_rules_hint (True)
    listview.set_headers_visible (False)
    listview.connect ('cursor-changed', self.on_listview_cursor_changed)
    listview.show ()
    sw.add (listview)

    renderer = gtk.CellRendererPixbuf ()
    tvcolumn = gtk.TreeViewColumn ()
    tvcolumn.pack_start (renderer, True)
    tvcolumn.add_attribute (renderer, 'pixbuf', CATEGORY_ICON)
    listview.append_column (tvcolumn)

    renderer = gtk.CellRendererText ()
    tvcolumn = gtk.TreeViewColumn ()
    tvcolumn.pack_start (renderer, True)
    tvcolumn.add_attribute (renderer, 'text', CATEGORY_NAME)
    listview.append_column (tvcolumn)

    # spinbutton
    hbox = gtk.HBox ()
    hbox.set_spacing (5)
    hbox.show ()
    self.vbox.pack_start (hbox, False)

    label = gtk.Label ('Amount')
    label.show ()
    hbox.pack_start (label, False)

    adj = gtk.Adjustment (1, 1, 9999, 1, 1, 0)
    self.spin = gtk.SpinButton (adj, 0, 0)
    self.spin.show ()
    hbox.pack_start (self.spin, False)

    placeholder = gtk.Label ()
    placeholder.show ()
    hbox.pack_start (placeholder)

    self.__category = None

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief Return amount of items
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def get_amount (self):
    return int (self.spin.get_value ())

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief Return select category
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def get_category (self):
    return self.__category

  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  # @brief Handle cursor changed event
  # =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-= 
  def on_listview_cursor_changed (self, treeview, *args):
    model, iter = treeview.get_selection ().get_selected ()
    if iter:
      self.__category = model.get_value (iter, CATEGORY_OBJECT)
