/* Copyright (C) 2012 Rudra Banerjee*/

/*
This file is part of mkbib.

mkbib is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

mkbib is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with mkbib.  If not, see <http://www.gnu.org/licenses/>.

*/
#include <string.h>
#include <glib/gstdio.h>
#include <fcntl.h>
#include <gtk/gtk.h>
#include "main.h"
GtkWidget *window,
          *flabel,
          *tree,
          *bibcombo;
char *filename,*key, *val;
GtkListStore *store;
GtkTreeIter siter;
#define slen 64

void output_entry (GHashTable *table)
{
  GHashTableIter iter;
  char *key, *val;
  char *keys[] = {"id", "type", "author", "year", "title", NULL};
  char *vals[] = {NULL,  NULL,  NULL,     NULL,   NULL   };
  char **kiter;
  int i;

  g_hash_table_iter_init (&iter, table);
  while (g_hash_table_iter_next (&iter, (void **)&key, (void **)&val))
    {
      for (kiter = keys, i = 0; *kiter; kiter++, i++)
        {
          if (!g_ascii_strcasecmp(*kiter, key))
            {
              vals[i] = g_strndup(val,slen);
              break;
            }
        }
    }

  gtk_list_store_append (store, &siter);
  gtk_list_store_set (store, &siter,
                      COL_BIB_KEY, vals[COL_BIB_KEY],
                      COL_BIB_TYPE, vals[COL_BIB_TYPE],
                      COL_BIB_NAME, vals[COL_BIB_NAME],
                      COL_BIB_YEAR, vals[COL_BIB_YEAR],
                      COL_BIB_PUB, vals[COL_BIB_PUB],
                      -1);
}

guint parse_entry (GScanner   *scanner,
             GHashTable *table)
{
  /* Entry starts with @ */
  g_scanner_get_next_token (scanner);
  if (scanner->token != '@')
    return G_TOKEN_ERROR;

  /* Now get identifier */
  g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_IDENTIFIER)
    return G_TOKEN_ERROR;

  g_hash_table_insert (table, g_strdup ("type"),
                       g_strdup (scanner->value.v_identifier));

  /* Brace */
  g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_LEFT_CURLY)
    return G_TOKEN_ERROR;

  /* ID */
  g_scanner_get_next_token (scanner);
  if (scanner->token != G_TOKEN_IDENTIFIER)
    return G_TOKEN_ERROR;

  g_hash_table_insert (table, g_strdup ("id"),
                       g_strdup (scanner->value.v_identifier));

  while (TRUE)
    {
      char *key, *val;

      g_scanner_get_next_token (scanner);
      if (scanner->token != G_TOKEN_COMMA)
        return G_TOKEN_ERROR;

      g_scanner_get_next_token (scanner);
      if (scanner->token != G_TOKEN_IDENTIFIER)
        return G_TOKEN_ERROR;

      key = g_strdup (scanner->value.v_identifier);

      g_scanner_get_next_token (scanner);
      if (scanner->token != '=')
        {
          g_free (key);
          return G_TOKEN_ERROR;
        }

      g_scanner_get_next_token (scanner);
      if (scanner->token != G_TOKEN_STRING)
        {
          g_free (key);
          return G_TOKEN_ERROR;
        }

      val = g_strdup (scanner->value.v_string);
      g_hash_table_insert(table, key, val);

      g_scanner_peek_next_token (scanner);
      if (scanner->next_token == G_TOKEN_RIGHT_CURLY)
        break;
    }

  g_scanner_get_next_token (scanner);
  return G_TOKEN_NONE;
}


GtkWidget *create_view_and_model(void) {
    GtkCellRenderer *cell;

  store = gtk_list_store_new (NUM_COLS, G_TYPE_STRING, G_TYPE_STRING,
                                                G_TYPE_STRING, 
                                                G_TYPE_STRING, 
                                                G_TYPE_STRING);

  tree = gtk_tree_view_new_with_model (GTK_TREE_MODEL (store));
  cell = gtk_cell_renderer_text_new ();
  GtkTreeViewColumn *col_key,*col_year,*col_type,*col_auth,*col_pub;
  col_key=gtk_tree_view_column_new_with_attributes (
      "Key", cell,
                                               "text", COL_BIB_KEY,
                                               NULL);
gtk_tree_view_column_set_sort_column_id( col_key, ID_KEY);
gtk_tree_view_append_column (GTK_TREE_VIEW (tree), col_key);

  cell = gtk_cell_renderer_text_new ();
  col_type=gtk_tree_view_column_new_with_attributes (
                                               "Type", cell,
                                               "text", COL_BIB_TYPE,
                                               NULL);
gtk_tree_view_column_set_sort_column_id( col_type, ID_TYPE);
gtk_tree_view_append_column (GTK_TREE_VIEW (tree), col_type);


  cell = gtk_cell_renderer_text_new ();
  col_auth=gtk_tree_view_column_new_with_attributes (
                                               "Author", cell,
                                               "text", COL_BIB_NAME,
                                               NULL);
gtk_tree_view_column_set_sort_column_id( col_auth, ID_NAME);
gtk_tree_view_append_column (GTK_TREE_VIEW (tree), col_auth);


  cell = gtk_cell_renderer_text_new ();
  col_year=gtk_tree_view_column_new_with_attributes (
                                               "Year", cell,
                                               "text", COL_BIB_YEAR,
                                               NULL);
gtk_tree_view_column_set_sort_column_id( col_year, ID_YEAR);
gtk_tree_view_append_column (GTK_TREE_VIEW (tree), col_year);


  cell = gtk_cell_renderer_text_new ();
  col_pub=gtk_tree_view_column_new_with_attributes (
                                               "Title", cell,
                                               "text", COL_BIB_PUB,
                                               NULL);
gtk_tree_view_column_set_sort_column_id( col_pub, ID_PUB);
gtk_tree_view_append_column (GTK_TREE_VIEW (tree), col_pub);


    return tree;
}




