/*- <matfquad/net/socket/Parameter.cpp> -*- C++ -*-
 *
 *
 *  matfquad
 *  Copyright (C) 2012  Márcio Adriano Tavares Fernandes
 *
 *  This library is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Lesser General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public License
 *  along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
#include "matfquad/net/socket/Parameter.hpp"
using namespace matfquad::net::socket;

Parameter::Parameter()
{
  this->number = -1;
}

Parameter::Parameter(int number): Parameter()
{
  this->number = number;
}

Parameter::Parameter(int number, std::string name): Parameter(number)
{
  this->name.assign(name);
}

Parameter::Parameter(int number, std::string name, std::vector <std::string> nicknames): Parameter(number, name)
{
  this->nicknames = nicknames;
}

std::string Parameter::getName()
{
  return this->name;
}

std::vector <std::string> Parameter::getNicknames()
{
  return this->nicknames;
}

int Parameter::getNumber()
{
  return this->number;
}
