#!/bin/sh
#   <configure.sh> -*- sh -*-
# 
# 
#   matfquad
#   Copyright (C) 2012  Márcio Adriano Tavares Fernandes
# 
#   This library is free software: you can redistribute it and/or modify
#   it under the terms of the GNU Lesser General Public License as published by
#   the Free Software Foundation, either version 3 of the License, or
#   (at your option) any later version.
# 
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
# 
#   You should have received a copy of the GNU Lesser General Public License
#   along with this library.  If not, see <http://www.gnu.org/licenses/>.
# 
# 

echo "Running $0 script..."

################################################################################
################################################################################
# SOCKETS ######################################################################
################################################################################
################################################################################

conftest_socket_macro()
{
cat << EOF | gcc -x c -std=gnu99 -pedantic-errors -Wall -Werror -Wextra -o conftest.run - && ./conftest.run && rm -f conftest.run
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>

int main()
{
  #ifdef $1
  fprintf(stdout, "true");
  #else
  fprintf(stdout, "false");
  #endif
  return EXIT_SUCCESS;
}
EOF
}

SOCKET_OPTION_COMPAT="false"

if [ "`conftest_socket_macro 'SO_PROTOCOL'`" == "false" ]; then
SOCKET_OPTION_COMPAT="true"
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX SO_PROTOCOL ##############################################################
/  static const int OPTION_PROTOCOL;/d
s/  int descriptor;/  int descriptor;\\
  int protocol_number;/g
EOF
fi

if [ "`conftest_socket_macro 'SO_TYPE'`" == "false" ]; then
SOCKET_OPTION_COMPAT="true"
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX SO_TYPE ##################################################################
/  static const int OPTION_TYPE;/d
s/  int descriptor;/  int descriptor;\\
  int type_number;/g
EOF
fi

if [ "`conftest_socket_macro 'SO_DOMAIN'`" == "false" ]; then
SOCKET_OPTION_COMPAT="true"
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX SO_DOMAIN ################################################################
/  static const int OPTION_FAMILY;/d
s/  int descriptor;/  int descriptor;\\
  int family_number;/g
EOF
fi

if [ "$SOCKET_OPTION_COMPAT" == "true" ]; then
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX Socket(int descriptor) ###################################################
/  Socket(int descriptor) throw (socket_error);/d
s/  Socket();/  Socket();\\
  Socket(int descriptor) throw (socket_error);/g
EOF
fi

if [ "`conftest_socket_macro 'MSG_DONTROUTE'`" == "false" ]; then
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX MSG_DONTROUTE ############################################################
/  static const int MESSAGE_DONTROUTE;/d
EOF
fi

if [ "`conftest_socket_macro 'MSG_DONTWAIT'`" == "false" ]; then
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX MSG_DONTWAIT #############################################################
/  static const int MESSAGE_DONTWAIT;/d
EOF
fi

if [ "`conftest_socket_macro 'MSG_NOSIGNAL'`" == "false" ]; then
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX MSG_NOSIGNAL #############################################################
/  static const int MESSAGE_NOSIGNAL;/d
EOF
fi

if [ "`conftest_socket_macro 'MSG_OOB'`" == "false" ]; then
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX MSG_OOB ##################################################################
/  static const int MESSAGE_OUTOFBAND;/d
EOF
fi

if [ "`conftest_socket_macro 'MSG_PEEK'`" == "false" ]; then
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX MSG_PEEK #################################################################
/  static const int MESSAGE_PEEK;/d
EOF
fi

if [ "`conftest_socket_macro 'MSG_WAITALL'`" == "false" ]; then
cat << EOF >> Socket_Compat.sed
################################################################################
# FIX MSG_WAITALL ##############################################################
/  static const int MESSAGE_WAITALL;/d
EOF
fi

################################################################################
################################################################################
# README -UTF8 #################################################################
################################################################################
################################################################################

utf8_replacechar()
{
cat << EOF >> $1.sed
s/$2/$3/g
EOF
}

utf8_removelines()
{
cat << EOF >> $1.sed
$2,$3d
EOF
}

utf8_center()
{
  wstring_len="`echo \"40-(\`echo $1 | wc -c\`/2)\" | bc`"
  wstring=""
  while [ "`echo \"\`echo \"$wstring\" | wc -c\` < $wstring_len\" | bc`" == "1" ]; do
   wstring="$wstring "
  done
  wstring="$wstring $1"
  echo "$wstring"
}

if [ "`echo \"$1\" | cut -c 1-9 `" == "matfquad-" ]; then
utf8_replacechar "README" " ┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓" "================================================================================"
utf8_replacechar "README" "┃┏━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┓" "================================================================================"
utf8_replacechar "README" "┃┗━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━━┛" "================================================================================"
utf8_replacechar "README" "█" "="
utf8_replacechar "README" "━"
utf8_replacechar "README" "┏"
utf8_replacechar "README" "┓"
utf8_replacechar "README" "┗"
utf8_replacechar "README" "┛"
utf8_replacechar "README" "┃"
utf8_replacechar "README" "┣"
utf8_replacechar "README" "┻"
utf8_replacechar "README" "○" "o"
utf8_replacechar "README" "▢" ""
utf8_removelines "README" 2 16
cat << EOF >> README.sed
1 i \\
\\
`utf8_center $1`
EOF
fi

echo "Done."

