#!$<$perl_path$>$

###############################################################################
# Copyright (C) 2006, 2007 Mariano Spadaccini	mariano@marianospadaccini.it  #
#									      #
# This file is part of MacAddressLocator.                                     #
#                                                                             #
#  MacAddressLocator is free software; you can redistribute it and/or modify  #
#  it under the terms of the GNU General Public License as published by       #
#  the Free Software Foundation; either version 2 of the License, or          #
#  (at your option) any later version.                                        #
#                                                                             #
#  MacAddressLocator is distributed in the hope that it will be useful,       #
#  but WITHOUT ANY WARRANTY; without even the implied warranty of             #
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              #
#  GNU General Public License for more details.                               #
#                                                                             #
#  You should have received a copy of the GNU General Public License          #
#  along with Foobar; if not, write to the Free Software                      #
#  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA #
###############################################################################

use lib '$<$pathFile$>$/inc';
use strict;
use warnings;

use myFunctionUtils;
use myFunctionShell;
use myFunctionDB;

use ParamSNMP qw(:swFetch);

# clear the screen
myFunctionShell::clearScreen;

# Header of 'find_mac.pl'
myFunctionShell::printHeader($0);

# it gets from you an switch's ip address
my ( $IP, $checkedIP );
print "\n\tPlease, You must insert";
do {
    print "\n\t\tIP address:\t";
    $IP = <STDIN>;
    chomp $IP;
    $checkedIP = myFunctionUtils::checkIP($IP);
} while ( !$checkedIP );

#### Connect to DB
my $dbh = myFunctionDB::connectToDB;

my $oldIdSwitch = myFunctionDB::getSwitchIDFromIP( $IP, $dbh );

if ( defined($oldIdSwitch) ) {
    print "\n\t\tThe inserted IP is already used from another ENABLED switch.";
    print "\n\t\tReinserted IP or DISABLE switch.";
}
else {
    my ($SNMPVersion);
    do {
        print "\n\t\tSNMP version (1 or 2):\t";
        $SNMPVersion = <STDIN>;
        chomp $SNMPVersion;
    } while ( !( ( $SNMPVersion eq '1' ) or ( $SNMPVersion eq '2' ) ) );

    # it asks: insert?
    my ($risp);
    do {
        print "\n\n\tInsert switch info in DB? [y/n] ";
        $risp = <STDIN>;
        chomp $risp;
        $risp = lc($risp);
    } while ( !( ( $risp eq 'n' ) || ( $risp eq 'y' ) ) );

    if ( $risp eq 'n' ) {

        # Now NOT insert
        print "\n\n\tOk, I do NOT insert switch info.";
    }
    else {

        # Now insert data switch with data DB
        print "\n\n\tStarting insert switch info...";
        my $idSwitch = myFunctionDB::insertSwitch( $dbh, $IP, $SNMPVersion );
        print " done";
        do {

            # It asks: now sync?
            print
              "\n\n\tFor working with new switch, you must ENABLE and SYNC.";
            print "\n\tDo you want to start ENABLE and SYNC? (y/n)\t";
            $risp = <STDIN>;
            chomp $risp;
            $risp = lc($risp);
        } while ( !( ( $risp eq 'n' ) || ( $risp eq 'y' ) ) );
        if ( $risp eq 'n' ) {

            # Now NOT sync
            print "\n\n\tOk, I do NOT ENABLE and do NOT SYNC switch info.";
        }
        else {

            # Now It enables the switch
            system "$<$pathFile$>$/utils/enable_switch.pl $idSwitch E";

            # Now sync data switch with data DB
            # print "\n\n\tStarting syncronization switch info...";
            system "$<$pathFile$>$/utils/sync_switch.pl $IP";
        }
    }
}

# press type to continue...
#myFunctionShell::typeToContinue;

exit 0;
